#include "stdlib.h"		// prototype for random

extern void line(int x1, int y1, int x2, int y2, int color);

void setVideo(int mode)
{
	asm {
		mov	ax,mode
		int	10h
	}
}

/*	Return:  0 if no key is available
**				1 if there a key to be read
**
**	Notes:   This function is much faster than the C kbhit that uses
**				the MS-DOS call AH=0Bh to check for a key.
*/
int bkbhit(void)
{
	asm {
		mov 	ah,1
		int 	16h		//use BIOS to see if a key if available
		mov	ax,0
		je 	nokey
		inc 	ax
	}
nokey:
	return _AX;
}

int bgetch(void)
{
    asm {
        mov     ah,0
        int     16h     //use BIOS to get a key
    }
    return _AL;
}
// try reducing the number of MAX_P, and commenting the bgetch line below...
#define MAX_P 5000    // maximum number of random points
#define ESC 0x1b

int x1[MAX_P], y1[MAX_P], x2[MAX_P], y2[MAX_P], color;


// The function random is extremely slow... It uses a bunch of
// multiplications...
void generatePoints(void)
{
    int i;

	for (i=0; i<MAX_P; i++) {	//	compute some random points ahead of time...
		x1[i] = random(320);
		x2[i] = random(320);
		y1[i] = random(200);
		y2[i] = random(200);
	}
}

int main(void)
{
    int i;

    setVideo(0x13);     // enter mode 13h, 320x200 w/ 256 colors

    color = 1;
	do {
        generatePoints();  // compute some random points...
//        color = 1;
// Ok, now it's time to draw some random lines...

// if you ever decide to time this routine, start your timing here.
        for (i=0; i<MAX_P; i++) {
			line(x1[i],y1[i],x2[i],y2[i], color++);
            if (bgetch() == ESC)      // try commenting these two lines
               goto exit2dos;         // just for testing...
		}
// stop timing here...
	} while (!bkbhit());

exit2dos:
	setVideo(3);		// return to mode 3, 80x25 w/ 16 colors

	return 0;
}

