


CALCTOOL(1L)      MISC. REFERENCE MANUAL PAGES       CALCTOOL(1L)



NAME
     calctool - a simple calculator

SYNOPSIS
     calctool [ -a _a_c_c_u_r_a_c_y ] [ -d _d_i_s_p_l_a_y ] [ -g _g_e_o_m_e_t_r_y ] [ -h
     _h_e_l_p_f_i_l_e ] [ -i ] [ -v ] [ -Wi ] [ -Wp _x _y ] [ -WP _x _y ]

DESCRIPTION
     _C_a_l_c_t_o_o_l is  a  simple  calculator.  It  contains  graphical
     interfaces for MGR, NeWS, SunView, X11 and XView, as well as
     being able to function on normal display terminals  using  a
     termcap interface. It can receive input via the keyboard, or
     the mouse where applicable. Each calculator button  has  two
     functions associated with it.

     Internal arithmetic is done with double  precision  floating
     point  numbers.   Accuracy can be adjusted from zero to nine
     numeric  places  in  fixed  notation,  but  numbers  can  be
     displayed  in  scientific  notation  as well. The calculator
     reverts to scientific notation when  the  number  is  larger
     than  the display would allow in fixed notation. The base of
     operation can be changed between binary, octal, decimal  and
     hexidecimal.  Numbers are initially displayed in fixed nota-
     tion to two numeric places, in the decimal base.

     You can use the SunView / XView _P_u_t and _G_e_t function keys in
     conjunction  with  the  numeric display to store or retrieve
     characters from the text shelf. The previous  digit  entered
     can be removed and the whole display cleared.

     There are ten memory registers; numbers can be retrieved  or
     stored  in  these locations, and arithmetic can be performed
     upon register contents.

     The display windows contains  the  current  numerical  value
     plus the current base and trigonometric type. There are also
     indicators which show if the hyperbolic and inverse function
     switches  are  set, and which numerical mode is currently in
     operation. If an operation needing more than  one  numerical
     input is partially complete, the operation is also displayed
     in this window as a reminder.

     The calculator has arithmetical, logical and trigonometrical
     functions.   These  are  grouped together and color coded on
     color workstations.

     With the SunView and XView versions, there  is  support  for
     popup  menus  with the right mouse button. Only certain but-
     tons which have multiple options have  this  ability.  These
     are the ACC, CON, EXCH, FUN, <, >, RCL and STO keys.





Sun Release 4.1   Last change: 13 December 1989                 1






CALCTOOL(1L)      MISC. REFERENCE MANUAL PAGES       CALCTOOL(1L)



     Online help is provided via a help button.  Select this but-
     ton,  and  then  the  function you wish to be described. The
     calctool windows can be redrawn by  typing  ^L  (control-l).
     This  is very useful with the tty version after somebody has
     written system messages all over your screen.

     On startup, _c_a_l_c_t_o_o_l will look for a ._c_a_l_c_t_o_o_l_r_c file in the
     users'  home  directory. This file allows the user to define
     their own constants and function definitions. It then  looks
     for  a  ._c_a_l_c_t_o_o_l_r_c  file in the current directory. With the
     ._c_a_l_c_t_o_o_l_r_c file, there  are  currently  four  valid  record
     types; comments, constants, function definitions and initial
     memory register values.

     Lines starting with  a  '#'  are  treated  as  comments  and
     ignored.

     Lines starting with 'c' or  'C'  in  the  first  column  are
     definitions  for constants. The cC is followed by a digit in
     the range 0-9, then a space.  This is followed by  a  number
     in  fixed  or  scientific  notation.  Following  this  is an
     optional comment, which if found, will be used in the  popup
     menu  for  the  constants.  If  the comment is present, then
     there must be at  least  one  space  between  this  and  the
     preceding number.

     Lines starting with 'f' or  'F'  in  the  first  column  are
     definitions  for functions. The fF is followed by a digit in
     the range 0-9, then a space. This is followed by a  function
     definition.  Following this is an optional comment, which if
     found, will be used in the popup menu for the functions.  If
     the  comment  is  present,  then  there must be at least one
     space between this and the preceding function definition.

     Lines starting with 'r' or  'R'  in  the  first  column  are
     definitions  for  the  initial contents of the memory regis-
     ters. The rR is followed by a digit in the range 0-9, then a
     space.  This  is followed by a number in fixed or scientific
     notation. The rest of the line is ignored.

     All other lines are ignored. There  should  be  no  embedded
     spaces  in the function definitions. Whenever a backslash is
     found, this and the following character  signify  a  control
     character, for example \g would be ASCII 7.

OPTIONS
     -a _a_c_c_u_r_a_c_y
          Initial number of significant  digits  displayed.  This
          value  must  be  in the range 0 to 9. If not specified,
          this value defaults to 2.

     -d _d_i_s_p_l_a_y



Sun Release 4.1   Last change: 13 December 1989                 2






CALCTOOL(1L)      MISC. REFERENCE MANUAL PAGES       CALCTOOL(1L)



          Used with the X11 variant of calctool to give a display
          type.

     -g _g_e_o_m_e_t_r_y
          Used with the X11 variant of calctool to give  geometry
          information.

     -h _h_e_l_p_f_i_l_e
          Use an alternate helpfile.

     -i   Invert the calctool window before  displaying  it.  For
          use by people who started their graphics environment in
          inverse mode.

     -v   Print the version number of this release of  the  calc-
          tool program.

     -Wi  Start the calctool program up in iconic  form.  SunView
          automatically uses this flag, but the NeWS version will
          also.

     -Wp _x _y
          Start the open window position at _x _y

     -WP _x _y
          Start the icon position at _x _y

CALCULATOR BUTTONS
     [Keyboard equivalents appear in brackets]

  Numerical Keys [ 0-9 a-f . = <RETURN> ].
     Enter a digit (decimal digits 0-9 or hexidecimal digits A-F)
     in  the  display.   The . acts as the decimal point and = is
     used for completion of numerical entry (<RETURN> can be also
     be used from the keyboard to terminate numerical entry).

  Arithmetical Operations [ + - x X * / ].
     Perform an arithmetical operation using the  previous  entry
     and the next entry as operands.  Addition, subtraction, mul-
     tiplication and division are denoted by the buttons +, -,  x
     and / respectively (the keyboard keys * and X are synonymous
     with x for multiplication).

  Base Changes.
     BIN  [ B ]        Change display base to binary (maximum: 32
                       digits).

     OCT  [ O ]        Change display base to octal (maximum:  15
                       digits). are allowed.

     DEC  [ D ]        Change display base to  decimal  (default;
                       maximum: 12 digits).



Sun Release 4.1   Last change: 13 December 1989                 3






CALCTOOL(1L)      MISC. REFERENCE MANUAL PAGES       CALCTOOL(1L)



     HEX  [ H ]        Change display base to  hexidecimal  (max-
                       imum: 12 digits).

  Trigonometric Unit Changes.
     DEG  [ ^d ]       Change  current  trigonometrical  base  to
                       degrees.

     RAD  [ ^r ]       Change the current trigonometrical base to
                       radians.

     GRAD [ ^g ]       Change the current trigonometrical base to
                       gradients.

  Logical Operations.
     AND  [ & ]        Perform a logical  AND  operation  on  the
                       current entry and the next entry, treating
                       both numbers as unsigned long integers.

     NOT  [ ~ ]        Perform the logical NOT operation  of  the
                       current entry.

     OR   [ | ]        Perform a  logical  OR  operation  on  the
                       current entry and the next entry, treating
                       both numbers as unsigned long integers.

     XNOR [ n or N ]   Perform a logical XNOR  operation  on  the
                       current entry and the next entry, treating
                       both numbers as unsigned long integers.

     XOR  [ ^ ]        Perform a logical  XOR  operation  on  the
                       current entry and the next entry, treating
                       both numbers as unsigned long integers.

  Trigonometrical Operators.
     SIN [ ^s ]        Return the trigonometric  sine,  arc  sine
                       hyperbolic sine or inverse hyperbolic sine
                       of the current display, depending upon the
                       current  settings  of  the  hyperbolic and
                       inverse function switches. The  result  is
                       displayed  in  the  current  trigonometric
                       units (degrees, radians or gradients).

     COS  [ ^c ]       Return  the  trigonometric   cosine,   arc
                       cosine hyperbolic cosine or inverse hyper-
                       bolic  cosine  of  the  current   display,
                       depending upon the current settings of the
                       hyperbolic and inverse function  switches.
                       The  result  is  displayed  in the current
                       trigonometric units (degrees,  radians  or
                       gradients).

     TAN  [ ^t ]       Return  the  trigonometric  tangent,   arc



Sun Release 4.1   Last change: 13 December 1989                 4






CALCTOOL(1L)      MISC. REFERENCE MANUAL PAGES       CALCTOOL(1L)



                       tangent   hyperbolic  tangent  or  inverse
                       hyperbolic tangent of the current display,
                       depending upon the current settings of the
                       hyperbolic and inverse function  switches.
                       The  result  is  displayed  in the current
                       trigonometric units (degrees,  radians  or
                       gradients).

  Memory Register Operators.
     RCL  [ r ]        Retrieve memory register n.   This  selec-
                       tion  must  be  followed by a digit in the
                       range 0 to 9 to indicate a  memory  regis-
                       ter.

     STO  [ s ]        Store memory register  n.   This  must  be
                       followed by a digit in the range 0 to 9 to
                       indicate a memory register.  The  register
                       number  may  be  preceded by an arithmetic
                       operation (addition,  subtraction,  multi-
                       plication  or division), in which case the
                       specifed operation is carred  out  between
                       the   displayed   entry   and   the  value
                       currently in register n, and the result is
                       placed in register n.

     EXCH [ ^e ]       Exchange the current display with the con-
                       tents  of  memory register n.  This selec-
                       tion must be followed by a  digit  in  the
                       range  0 to 9, to indicate a memory regis-
                       ter.

  Mathematical Operators.
     %    [ % ]        Perform a percentage calculation using the
                       last entry and the next entry.

     e^x  [ { ]        Return  e  raised  to  the  power  of  the
                       current entry.

     10^x [ } ]        Return 10  raised  to  the  power  of  the
                       current entry.

     y^x  [ Y ]        Take the last entry and raise  it  to  the
                       power of the next entry.

     ln   [ N ]        Return  the  natural  logarithm   of   the
                       current entry.

     log  [ G ]        Returns  the  base  10  logarithm  of  the
                       current entry.

     SQRT [ S ]        Perform a square  root  operation  on  the
                       current entry.



Sun Release 4.1   Last change: 13 December 1989                 5






CALCTOOL(1L)      MISC. REFERENCE MANUAL PAGES       CALCTOOL(1L)



     1/x  [ R ]        Return the  value  of  1  divided  by  the
                       current entry.

     x!   [ ! ]        Return the factorial of the current entry.
                       Note  that  this  only  works for positive
                       integers.

     x^2  [ @ ]        Return the square of the current entry.

  Number Manipulation Operators.
     <    [ < ]        Left shift n places. This must be followed
                       by a digit in the range 0 to 9 to indicate
                       the number of places to shift.

     >    [ > ]        Right shift n places. This  must  be  fol-
                       lowed  by  a  digit in the range 0 to 9 to
                       indicate the number of places to shift.

     &32  [ [ ]        Truncate the current entry  to  a  32  bit
                       unsigned integer (logical function).

     &16  [ ] ]        Truncate the given  number  to  a  16  bit
                       unsigned integer (logical function).

     clr  [ Delete ]   Clear the calculator display.

     bsp  [ BackSpace ]
                       Remove  the  rightmost  character  of  the
                       current  entry  and  recalculate  the  the
                       displayed value (note:  internal  accuracy
                       is lost with this operation).

     INT  [ I ]        Return the integer portion of the  current
                       entry.

     FRAC [ F ]        Return  the  fractional  portion  of   the
                       current entry.

     ACC  [ A ]        Set accuracy. This must be followed  by  a
                       digit  in the range 0 to 9 to indicate how
                       many digits are to be displayed.

     CHS  [ C ]        Change the arithmetic sign of the  current
                       entry.

     ABS  [ U ]        Return the absolute value of  the  current
                       entry.

  Other keys.
     MEM  [ M ]        Toggle the display of the  popup  register
                       window.   Values  of the ten memory regis-
                       ters are displayed in the current base, to



Sun Release 4.1   Last change: 13 December 1989                 6






CALCTOOL(1L)      MISC. REFERENCE MANUAL PAGES       CALCTOOL(1L)



                       the current accuracy.

     FIX / SCI  [ ^n ] Toggles the numerical display mode between
                       fixed  point and scientific notation. This
                       affects the current display and  the  con-
                       tents of the memory registers.

     CON  [ # ]        Retrieve and  display  constant  value  n.
                       This selection must be followed by a digit
                       in the range 0 to 9.
                       The ten default constants are:

                       0 - kms per hour / miles per hour.
                       1 - square root of 2.
                       2 - e.
                       3 - pi.
                       4 - cms / inches.
                       5 - degrees in a radian.
                       4 - 2 ^ 20.
                       6 - gms / oz.
                       8 - kilojoules / British thermals.
                       9 - cubic cms / cubic inches.

     HYP  [ h ]        Set or unset the hyperbolic function indi-
                       cator.  This  switch  affects  the type of
                       sine,  cosine  and  tangent  trigonometric
                       functions performed.

     INV  [ i ]        Set or unset the inverse function  indica-
                       tor. This switch affects the type of sine,
                       cosine and tangent trigonometric functions
                       performed.

     KEYS [ K ]        Toggle the labels on the calctool  buttons
                       between mouse and keyboard equivalents.

     ?    [ ? ]        Display a help message  for  a  particular
                       button.   First  select this key, then the
                       key to be described.

     QUIT [q or Q]     Exit (without user verification).

     OFF  [ o ]        Change _c_a_l_c_t_o_o_l to an icon.

FILES
     /usr/local/lib/calctool.help

     /usr/local/lib/calctool.ps

     ~/.calctoolrc





Sun Release 4.1   Last change: 13 December 1989                 7






CALCTOOL(1L)      MISC. REFERENCE MANUAL PAGES       CALCTOOL(1L)



BUGS
     Handling of errors generated by the mathematical routines is
     poorly done.

AUTHOR
     Rich Burridge,        Domain: richb@sunaus.oz.au
     PHONE: +61 2 413 2666   Path: {uunet,mcvax,ukc}!munnari!sunaus.oz!richb
     Original manual page modified by  R.  P.  C.  Rodgers,  UCSF
     School of Pharmacy, San Francisco, CA 94143.














































Sun Release 4.1   Last change: 13 December 1989                 8



