/*
Mandelbrot Set display
Lee F. Holeva
12/6/93
*/
// display a DOS window
#define WIN31
#define TEXTBUFSIZE 100
#include <owl.h>
#include <complex.h>
#include <iostream.h>

#pragma argsused

/*
Derived Window application class
*/
class TLeesWinAppl : public TApplication{
public:
	TLeesWinAppl(LPSTR AName, HANDLE hInstance, HANDLE hPrevInstance,
	LPSTR lpCmdLine, int nCmdShow) : TApplication(AName, hInstance,
	hPrevInstance, lpCmdLine, nCmdShow){}
	virtual void InitMainWindow();
};

/*
Derived Window class
*/
class TLeesWin : public TWindow{
public:
	TLeesWin(PTWindowsObject AParent, LPSTR ATitle)
	: TWindow(AParent, ATitle){}

	/*
	This function gets called to display graphics in the window
	*/
	virtual void Paint(HDC hDC, PAINTSTRUCT&);
};

/*
Graphics code goes here:
Compute the Mandelbrot set
*/
void TLeesWin::Paint(HDC hDC, PAINTSTRUCT&)
{
	int i,n,m,width,height,outside;
	double x, y;
	complex func = complex(0, 0);
	complex c = complex(0, 0);

	/* get the screen size */
	width=GetDeviceCaps(hDC, HORZRES);
	height=GetDeviceCaps(hDC, VERTRES);
	cout << "Screen width = " << width << "\n";
	cout << "Screen height = " << height << "\n";

        /* For each screen coordinate, determine wether the orbit diverges to infinity */
	for(m=0;m<width;m++){

		x = -1.5 + 3.0*(double)m/(double)width;
		for(n=0;n<height/2;n++){

			y = 1.5 - 3.0*(double)n/(double)height;
			c = complex(x, y);
			outside = 0;

                        /* iterate the function from a complex point */
			func = c;
			for(i=0;i<300;i++){

				func = func*func + c;
				if(norm(func) > 4.0){
					outside = 1;
					break;
                                }
			}
    
			/* Red if attracted to zero, yellow if divergent to infinity */
			if(outside){
				SetPixel(hDC, m, n, RGB(255, 255, 0));
				SetPixel(hDC, m, height-n-1, RGB(255, 255, 0));
                        }
			else{
				SetPixel(hDC, m, n, RGB(255, 0, 0));
				SetPixel(hDC, m, height-n-1, RGB(255, 0, 0));
			}
		}
        }
}

/*
Windows application code goes here
*/
void TLeesWinAppl::InitMainWindow()
{
	TLeesWin *leeswinp;

	leeswinp=new TLeesWin(NULL, "Lee's Graphics Window");			// Create a new window
	MainWindow=leeswinp;

}

/*
Main window routine
*/
int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
			LPSTR lpCmdLine, int nCmdShow)
{
	char text_buf[TEXTBUFSIZE];
	TLeesWinAppl LeesAppl("Lees Window Application", hInstance,
	hPrevInstance, lpCmdLine, nCmdShow);

	_InitEasyWin();		       // Enable DOS I/O for the window

 	LeesAppl.Run();			// Run the Windows application
	return LeesAppl.Status;
}
