/********************************************************************
Copyright (c) 1993  Sing Li, Media Synergy Inc.  All Rights Reserved

Module Name:

    Cdnow.h

Abstract:
    This is the Scsi miniport driver for Panasonic 52x using
	 native or compatible controllers.

	 This module contains definitions for cdnow.c and cdread.c routines.
**********************************************************************/
#include "scsi.h"


#define BASE_PORT		0x0300
#define NUMBER_PORTS        4
#define PORT_INC			0x020	
#define PORT_SLOTS			 5  
// searches 300,320,340,360,380; always +1!

									  
#define	ANY_TIMED_OUT		dExt->TimedOut
#define 	CLEAR_TIMED_OUT	dExt->TimedOut = FALSE

// Panasonic Status Bits
#define PAN_CHK         1
#define PAN_AUDIO_PLAY  4
#define PAN_CMD_DONE    8
#define PAN_ERROR       16
#define PAN_SPIN        32
#define PAN_DISC_IN     64
#define PAN_INFERR      128



//
// Interrupt definition.
//
#define CDNOW_IDT_VECTOR    5

//
// SCSI source identifier for host system.
//
#define SCSI_INITIATOR_ID   7



//
// Logical Unit states.
//
typedef enum _LU_STATE {

    LS_UNDETERMINED,
    LS_ARBITRATE,
    LS_SELECT,
    LS_IDENTIFY,
    LS_MSG_SPECIAL,
    LS_COMMAND,
    LS_DATA,
    LS_DISCONNECTED,
    LS_ABORT,
    LS_STATUS,
    LS_MSG_IN,
    LS_COMPLETE

} LU_STATE, *PLU_STATE;

#define min(l, r)   (((l) < (r)) ? (l) : (r))

//
// Logical Unit extension
//
typedef struct _SPECIFIC_LU_EXTENSION {
    LU_STATE		LuState;	    // State information.
    UCHAR		AbortBeingAttempted;
    ULONG		SavedDataPointer;   // Current data pointer.
    ULONG		SavedDataLength;    // Current data lenght.
    PSCSI_REQUEST_BLOCK ActiveLuRequest;    // Active Srb for this LUN.
} SPECIFIC_LU_EXTENSION, *PSPECIFIC_LU_EXTENSION;

//
// Device extension
//
typedef struct _SPECIFIC_DEVICE_EXTENSION {

    PUCHAR		BaseAddress;	    // Memory map address of adapter.
    ULONG		CurDataPointer;     // Current pointer for active LUN.
    ULONG		CurDataLength;	    // Bytes left to xfer to this LUN.
    PSPECIFIC_LU_EXTENSION  SavedLu;	    // Saved LUN during interrupts.
    PSPECIFIC_LU_EXTENSION  ActiveLu;	    // Currently active LUN.
    UCHAR		PathId;
    UCHAR		ControlRegister;    // Current val of CDnow control reg.
    USHORT		PortBase;
    BOOLEAN		TimedOut;
} SPECIFIC_DEVICE_EXTENSION, *PSPECIFIC_DEVICE_EXTENSION;


