'*** BASIC Adaptive Block Coded (ABC) Image Compression ***
'*** (c)1993, E.F.Deel, CIS 72627,3026 ***
'*** DECOMP.BAS - De-Compression Subroutine Module ***
'!!! NOTE !!! - Compile with /R: BC DECOMP /O/OT/R
'               Link with PDQ library by Crescent Software for smaller,
'               faster results.

DEFINT A-Z

'$INCLUDE: 'DECOMP.DCL'

TYPE ZigZag
   Row AS INTEGER
   Col AS INTEGER
END TYPE

REDIM SHARED c(0)

END  '--- End of Module level code



'--- Sub-Programs -------------------

SUB DeCompress (FileIn$, BYVAL X, BYVAL Y, OK)

   DIM ABCHdr AS STRING * 20
   REDIM c(7)
   REDIM BCodes(1200)
   REDIM PCodes(19200)
   REDIM Pixels(32766)
   REDIM zl(63) AS ZigZag
   REDIM zr(63) AS ZigZag
   REDIM pel(7, 7)
   REDIM colr(15, 1)


   '--- Define power of 2 constants for bit shifting and masking

   c(7) = 128
   c(6) = 64
   c(5) = 32
   c(4) = 16
   c(3) = 8
   c(2) = 4
   c(1) = 2
   c(0) = 1

   '--- Define row/column constants for zigzag patterns left & right

   zl(0).Row = 0: zl(0).Col = 0
   zl(1).Row = 0: zl(1).Col = 1
   zl(2).Row = 1: zl(2).Col = 0
   zl(3).Row = 2: zl(3).Col = 0
   zl(4).Row = 1: zl(4).Col = 1
   zl(5).Row = 0: zl(5).Col = 2
   zl(6).Row = 0: zl(6).Col = 3
   zl(7).Row = 1: zl(7).Col = 2
   zl(8).Row = 2: zl(8).Col = 1
   zl(9).Row = 3: zl(9).Col = 0
   zl(10).Row = 4: zl(10).Col = 0
   zl(11).Row = 3: zl(11).Col = 1
   zl(12).Row = 2: zl(12).Col = 2
   zl(13).Row = 1: zl(13).Col = 3
   zl(14).Row = 0: zl(14).Col = 4
   zl(15).Row = 0: zl(15).Col = 5
   zl(16).Row = 1: zl(16).Col = 4
   zl(17).Row = 2: zl(17).Col = 3
   zl(18).Row = 3: zl(18).Col = 2
   zl(19).Row = 4: zl(19).Col = 1
   zl(20).Row = 5: zl(20).Col = 0
   zl(21).Row = 6: zl(21).Col = 0
   zl(22).Row = 5: zl(22).Col = 1
   zl(23).Row = 4: zl(23).Col = 2
   zl(24).Row = 3: zl(24).Col = 3
   zl(25).Row = 2: zl(25).Col = 4
   zl(26).Row = 1: zl(26).Col = 5
   zl(27).Row = 0: zl(27).Col = 6
   zl(28).Row = 0: zl(28).Col = 7
   zl(29).Row = 1: zl(29).Col = 6
   zl(30).Row = 2: zl(30).Col = 5
   zl(31).Row = 3: zl(31).Col = 4
   zl(32).Row = 4: zl(32).Col = 3
   zl(33).Row = 5: zl(33).Col = 2
   zl(34).Row = 6: zl(34).Col = 1
   zl(35).Row = 7: zl(35).Col = 0
   zl(36).Row = 7: zl(36).Col = 1
   zl(37).Row = 6: zl(37).Col = 2
   zl(38).Row = 5: zl(38).Col = 3
   zl(39).Row = 4: zl(39).Col = 4
   zl(40).Row = 3: zl(40).Col = 5
   zl(41).Row = 2: zl(41).Col = 6
   zl(42).Row = 1: zl(42).Col = 7
   zl(43).Row = 2: zl(43).Col = 7
   zl(44).Row = 3: zl(44).Col = 6
   zl(45).Row = 4: zl(45).Col = 5
   zl(46).Row = 5: zl(46).Col = 4
   zl(47).Row = 6: zl(47).Col = 3
   zl(48).Row = 7: zl(48).Col = 2
   zl(49).Row = 7: zl(49).Col = 3
   zl(50).Row = 6: zl(50).Col = 4
   zl(51).Row = 5: zl(51).Col = 5
   zl(52).Row = 4: zl(52).Col = 6
   zl(53).Row = 3: zl(53).Col = 7
   zl(54).Row = 4: zl(54).Col = 7
   zl(55).Row = 5: zl(55).Col = 6
   zl(56).Row = 6: zl(56).Col = 5
   zl(57).Row = 7: zl(57).Col = 4
   zl(58).Row = 7: zl(58).Col = 5
   zl(59).Row = 6: zl(59).Col = 6
   zl(60).Row = 5: zl(60).Col = 7
   zl(61).Row = 6: zl(61).Col = 7
   zl(62).Row = 7: zl(62).Col = 6
   zl(63).Row = 7: zl(63).Col = 7

   zr(0).Row = 0: zr(0).Col = 7
   zr(1).Row = 0: zr(1).Col = 6
   zr(2).Row = 1: zr(2).Col = 7
   zr(3).Row = 2: zr(3).Col = 7
   zr(4).Row = 1: zr(4).Col = 6
   zr(5).Row = 0: zr(5).Col = 5
   zr(6).Row = 0: zr(6).Col = 4
   zr(7).Row = 1: zr(7).Col = 5
   zr(8).Row = 2: zr(8).Col = 6
   zr(9).Row = 3: zr(9).Col = 7
   zr(10).Row = 4: zr(10).Col = 7
   zr(11).Row = 3: zr(11).Col = 6
   zr(12).Row = 2: zr(12).Col = 5
   zr(13).Row = 1: zr(13).Col = 4
   zr(14).Row = 0: zr(14).Col = 3
   zr(15).Row = 0: zr(15).Col = 2
   zr(16).Row = 1: zr(16).Col = 3
   zr(17).Row = 2: zr(17).Col = 4
   zr(18).Row = 3: zr(18).Col = 5
   zr(19).Row = 4: zr(19).Col = 6
   zr(20).Row = 5: zr(20).Col = 7
   zr(21).Row = 6: zr(21).Col = 7
   zr(22).Row = 5: zr(22).Col = 6
   zr(23).Row = 4: zr(23).Col = 5
   zr(24).Row = 3: zr(24).Col = 4
   zr(25).Row = 2: zr(25).Col = 3
   zr(26).Row = 1: zr(26).Col = 2
   zr(27).Row = 0: zr(27).Col = 1
   zr(28).Row = 0: zr(28).Col = 0
   zr(29).Row = 1: zr(29).Col = 1
   zr(30).Row = 2: zr(30).Col = 2
   zr(31).Row = 3: zr(31).Col = 3
   zr(32).Row = 4: zr(32).Col = 4
   zr(33).Row = 5: zr(33).Col = 5
   zr(34).Row = 6: zr(34).Col = 6
   zr(35).Row = 7: zr(35).Col = 7
   zr(36).Row = 7: zr(36).Col = 6
   zr(37).Row = 6: zr(37).Col = 5
   zr(38).Row = 5: zr(38).Col = 4
   zr(39).Row = 4: zr(39).Col = 3
   zr(40).Row = 3: zr(40).Col = 2
   zr(41).Row = 2: zr(41).Col = 1
   zr(42).Row = 1: zr(42).Col = 0
   zr(43).Row = 2: zr(43).Col = 0
   zr(44).Row = 3: zr(44).Col = 1
   zr(45).Row = 4: zr(45).Col = 2
   zr(46).Row = 5: zr(46).Col = 3
   zr(47).Row = 6: zr(47).Col = 4
   zr(48).Row = 7: zr(48).Col = 5
   zr(49).Row = 7: zr(49).Col = 4
   zr(50).Row = 6: zr(50).Col = 3
   zr(51).Row = 5: zr(51).Col = 2
   zr(52).Row = 4: zr(52).Col = 1
   zr(53).Row = 3: zr(53).Col = 0
   zr(54).Row = 4: zr(54).Col = 0
   zr(55).Row = 5: zr(55).Col = 1
   zr(56).Row = 6: zr(56).Col = 2
   zr(57).Row = 7: zr(57).Col = 3
   zr(58).Row = 7: zr(58).Col = 2
   zr(59).Row = 6: zr(59).Col = 1
   zr(60).Row = 5: zr(60).Col = 0
   zr(61).Row = 6: zr(61).Col = 0
   zr(62).Row = 7: zr(62).Col = 1
   zr(63).Row = 7: zr(63).Col = 0

   GOSUB ReadFile
   IF NOT OK THEN EXIT SUB

   bcseg = VARSEG(BCodes(1))  'setup BASIC simulated pointers for
   bcptr = VARPTR(BCodes(1))  'direct memeory access
   pcseg = VARSEG(PCodes(1))
   pcptr = VARPTR(PCodes(1))
   pelseg = VARSEG(Pixels(1))
   pelptr = VARPTR(Pixels(1))
   putseg = VARSEG(pel(0, 0))
   putptr = VARPTR(pel(0, 0))

   IF BCodes(0) THEN           'Do 1-D decompression if necessary
      CALL ExpandArray(bcseg, bcptr, bct&, BCodes(0))
      bct& = bct& + 2
   END IF
   IF PCodes(0) THEN
      CALL ExpandArray(pcseg, pcptr, pct&, PCodes(0))
      pct& = pct& + 2
   END IF
   IF Pixels(0) THEN
      CALL ExpandArray(pelseg, pelptr, plt&, Pixels(0))
      plt& = plt& + 2
   END IF
   ULR = Y

   FOR i = 1 TO BHigh   '-------------Main De-Compression Loop ---------------
      ULC = X
      FOR j = 1 TO BWide

         IF bcflg THEN          'get block pattern code
            bc = bcb AND 15
            bcflg = 0
         ELSE
            DEF SEG = bcseg
            bcb = PEEK(bcptr)
            bcptr = bcptr + 1
            bc = bcb \ 16
            bcflg = -1
         END IF

         SELECT CASE bc         'select de-compression code for block

            CASE 0      'No compression
               FOR k = 0 TO 7
                  FOR l = 0 TO 7
                     GOSUB InPel
                     pel(k, l) = lp
                  NEXT l
               NEXT k

            CASE 1     'Horizontal Run
               FOR k = 0 TO 7
                  GOSUB InPC
                  FOR l = 0 TO 7
                     IF pc AND c(7 - l) THEN GOSUB InPel
                     pel(k, l) = lp
                  NEXT l
               NEXT k

            CASE 2     'Vertical Run
               FOR k = 0 TO 7
                  GOSUB InPC
                  FOR l = 0 TO 7
                     IF pc AND c(7 - l) THEN GOSUB InPel
                     pel(l, k) = lp
                  NEXT l
               NEXT k

            CASE 3      'prime color
               GOSUB InPel
               pcolr = p
               FOR k = 0 TO 7
                  GOSUB InPC
                  FOR l = 0 TO 7
                     IF pc AND c(7 - l) THEN
                        GOSUB InPel
                        pel(k, l) = lp
                     ELSE
                        pel(k, l) = pcolr
                     END IF
                  NEXT l
               NEXT k

            CASE 4      'Left zigzag
               cnt = 0
               FOR k = 0 TO 63
                  IF cnt = 0 THEN
                     GOSUB InPC
                     cnt = 7
                  ELSE
                     cnt = cnt - 1
                  END IF
                  IF pc AND c(cnt) THEN GOSUB InPel
                  pel(zl(k).Row, zl(k).Col) = lp
               NEXT k

            CASE 5      'Right zigzag
               cnt = 0
               FOR k = 0 TO 63
                  IF cnt = 0 THEN
                     GOSUB InPC
                     cnt = 7
                  ELSE
                     cnt = cnt - 1
                  END IF
                  IF pc AND c(cnt) THEN GOSUB InPel
                  pel(zr(k).Row, zr(k).Col) = lp
               NEXT k

            CASE 6        'single color
               GOSUB InPel
               FOR k = 0 TO 7
                  FOR l = 0 TO 7
                     pel(k, l) = p
                  NEXT l
               NEXT k

            CASE 7        'two colors
               nocolr = 1
               GOSUB InColrs
               FOR k = 0 TO 7
                  GOSUB InPC
                  FOR l = 0 TO 7
                     IF pc AND c(7 - l) THEN
                        pel(k, l) = colr(0, 0)
                     ELSE
                        pel(k, l) = colr(1, 0)
                     END IF
                  NEXT l
               NEXT k

            CASE 8, 9     '3,4 colors
               nocolr = bc - 6
               GOSUB InColrs
               FOR k = 0 TO 7
                  GOSUB InPC
                  pc1 = pc
                  GOSUB InPC
                  pc2 = pc
                  FOR l = 0 TO 7
                     p = 0
                     t = 7 - l
                     IF pc1 AND c(t) THEN p = p OR 1
                     IF pc2 AND c(t) THEN p = p OR 2
                     pel(k, l) = colr(p, 0)
                  NEXT l
               NEXT k

            CASE IS > 9    '5 to 8 colors
               nocolr = bc - 6
               GOSUB InColrs
               FOR k = 0 TO 7
                  GOSUB InPC
                  pc1 = pc
                  GOSUB InPC
                  pc2 = pc
                  GOSUB InPC
                  pc3 = pc
                  FOR l = 0 TO 7
                     p = 0
                     t = 7 - l
                     IF pc1 AND c(t) THEN p = p OR 1
                     IF pc2 AND c(t) THEN p = p OR 2
                     IF pc3 AND c(t) THEN p = p OR 4
                     pel(k, l) = colr(p, 0)
                  NEXT l
               NEXT k
         END SELECT
         CALL PutI(putseg, putptr, ULC, ULR, 8, 8)'Put the block on screen
         ULC = ULC + 8                            'point to next block
      NEXT j
      ULR = ULR + 8                               'point to next block row
   NEXT i
   DEF SEG                                        'restore segment pointer
EXIT SUB


'--- GOSUB's for code blocks using common data

ReadFile:
   FileNum = FREEFILE
   OPEN FileIn$ FOR BINARY AS #FileNum
      fsize& = LOF(FileNum)
      IF fsize& = 0 THEN GOTO Abort
      GET FileNum, , ABCHdr
      IF CVI(MID$(ABCHdr, 1, 2)) <> 5357 THEN GOTO Abort  'signature

      XSize = CVI(MID$(ABCHdr, 3, 2))                     'image width
      YSIZE = CVI(MID$(ABCHdr, 5, 2))                     'image height
      bct& = CVI(MID$(ABCHdr, 11, 2))                     'block code size
      pct& = CVL(MID$(ABCHdr, 13, 4))                     'pattern code side
      plt& = CVL(MID$(ABCHdr, 17, 4))                     'pixel coefficients

      BWide = (XSize + 7) \ 8                             'width in blocks
      BHigh = (YSIZE + 7) \ 8                             'height in blocks
      IF BWide > 80 THEN BWide = 80
      IF BHigh > 60 THEN BHigh = 60
      rsize& = BWide * BHigh * 32&
      BSize = BWide * 8

      t$ = SPACE$(3)                   'read and set image palette
      FOR k = 0 TO 15
         GET FileNum, , t$
         CALL SetPaletteEGA(k, k)
         r = ASC(MID$(t$, 1))
         g = ASC(MID$(t$, 2))
         b = ASC(MID$(t$, 3))
         CALL SetPalTripleVGA(k, r, g, b)
      NEXT k

      '--- Read complete data arrays from disk in one operation
      CALL BlkGet(FileNum, VARSEG(BCodes(0)), VARPTR(BCodes(0)), bct&)
      CALL BlkGet(FileNum, VARSEG(PCodes(0)), VARPTR(PCodes(0)), pct&)
      CALL BlkGet(FileNum, VARSEG(Pixels(0)), VARPTR(Pixels(0)), plt&)

   CLOSE FileNum
   OK = -1
RETURN


InPel:
   IF pelflg THEN
      p = pb AND 15
      pelflg = 0
   ELSE
      DEF SEG = pelseg
      pb = PEEK(pelptr)
      pelptr = pelptr + 1
      p = pb \ 16
      pelflg = -1
   END IF
   lp = p
RETURN


InPC:
   DEF SEG = pcseg
   pc = PEEK(pcptr)
   pcptr = pcptr + 1
RETURN


InBC:
   IF bcflg THEN
      bc = bcb AND 15
      bcflg = 0
   ELSE
      DEF SEG = bcseg
      bcb = PEEK(bcptr)
      bcptr = bcptr + 1
      bc = bcb \ 16
      bcflg = -1
   END IF
RETURN


InColrs:
   FOR k = 0 TO nocolr
      GOSUB InPel
      colr(k, 0) = p
   NEXT k
RETURN

Abort:
   CLOSE FileNum
   OK = 0
   BEEP
RETURN

END SUB



SUB ExpandArray (BYVAL inseg, BYVAL inptr, bytesz&, NoBlk)

   REDIM OutBfr(32766)
   REDIM CBlk(15)

   scnt = -1
   lc = 0
   scb = 0
   outseg = VARSEG(OutBfr(0))
   outptr = VARPTR(OutBfr(0))
   DEF SEG = inseg
   scptr = inptr
   ccptr = PEEK(scptr) + PEEK(scptr + 1) * 256
   ccptr = ccptr + scptr
   chptr = PEEK(ccptr) + PEEK(ccptr + 1) * 256
   chptr = chptr + ccptr
   scptr = scptr + 2
   ccptr = ccptr + 2
   chptr = chptr + 2
   FOR j = 1 TO NoBlk
      sc = 0
      IF scnt < 0 THEN GOSUB GetSC
      IF scb AND c(scnt) THEN sc = sc OR 1
      IF scb AND c(scnt - 1) THEN sc = sc OR 2
      scnt = scnt - 2
      SELECT CASE sc
         CASE 0
            FOR k = 0 TO 15
               DEF SEG = inseg
               ch = PEEK(chptr)
               chptr = chptr + 1
               DEF SEG = outseg
               POKE outptr, ch
               outptr = outptr + 1
            NEXT k
            otsz& = otsz& + 16
            lc = ch
         CASE 1
            GOSUB GetCC
            FOR k = 0 TO 7
               IF cc1 AND c(7 - k) THEN
                  GOSUB GetCh
                  CBlk(k) = ch
               ELSE
                  CBlk(k) = lc
               END IF
            NEXT k
            FOR k = 8 TO 15
               IF cc2 AND c(15 - k) THEN
                  GOSUB GetCh
                  CBlk(k) = ch
               ELSE
                  CBlk(k) = lc
               END IF
            NEXT k
            GOSUB PutCBlk
         CASE 2
            GOSUB GetCC
            GOSUB GetCh
            prchr = ch
            FOR k = 0 TO 7
               IF cc1 AND c(7 - k) THEN
                  GOSUB GetCh
                  CBlk(k) = ch
               ELSE
                  CBlk(k) = prchr
               END IF
            NEXT k
            FOR k = 8 TO 15
               IF cc2 AND c(15 - k) THEN
                  GOSUB GetCh
                  CBlk(k) = ch
               ELSE
                  CBlk(k) = prchr
               END IF
            NEXT k
            GOSUB PutCBlk
         CASE ELSE
            BEEP
      END SELECT
   NEXT j

   bytesz& = otsz&
   outptr = VARPTR(OutBfr(0))
   CALL BlockCopy(outseg, outptr, inseg, inptr, otsz&)'put uncompressed data
EXIT SUB                                            'back into input array


'--- GOSUB's for code blocks using common data

PutCBlk:
   DEF SEG = outseg
   FOR k = 0 TO 15
      POKE outptr, CBlk(k)
      outptr = outptr + 1
      otsz& = otsz& + 1
   NEXT k
RETURN

GetSC:
   DEF SEG = inseg
   scb = PEEK(scptr)
   scptr = scptr + 1
   scnt = 7
RETURN

GetCC:
   DEF SEG = inseg
   cc1 = PEEK(ccptr)
   ccptr = ccptr + 1
   cc2 = PEEK(ccptr)
   ccptr = ccptr + 1
RETURN

GetCh:
   DEF SEG = inseg
   ch = PEEK(chptr)
   chptr = chptr + 1
   lc = ch
RETURN

END SUB

