'*** BASIC Adaptive Block Coded (ABC) Image Compression ***
'*** (c)1993, E.F.Deel, CIS 72627,3026 ***
'*** COMP.BAS - Compression Subroutine Module ***

DEFINT A-Z   '--- Use integers as default data type

'$INCLUDE: 'COMP.DCL'

'Share compression statistics among modules (optional)
COMMON SHARED noc, hrc, vrc, pcc, zlc, zrc, vlc, bct&, pct&, plt&, GPDat%()

TYPE ZigZag
   Row AS INTEGER
   Col AS INTEGER
END TYPE

REDIM SHARED c(0)          'initialize dynamic arrays to be shared by all
REDIM SHARED BCodes(0)     '   sub-programs in this module
REDIM SHARED PCodes(0)
REDIM SHARED Pixels(0)

END    '--- End of Module level Code ---



'--- Sub-Programs -------------------

SUB Compress (BYVAL X, BYVAL Y, BYVAL XSize, BYVAL YSize, BYVAL Lossy, rsize&, csize&)

   REDIM zl(63) AS ZigZag
   REDIM zr(63) AS ZigZag
   REDIM c(7)
   REDIM ts(6)
   REDIM tp(6)
   REDIM pel(7, 7)
   REDIM hr(7, 7)
   REDIM vr(7, 7)
   REDIM pr(7, 7)
   REDIM lz(63)
   REDIM rz(63)
   REDIM colr(15, 1)
   REDIM BCodes(1200)
   REDIM PCodes(16383)
   REDIM Pixels(32766)
   REDIM MoveBfr(1 TO 1282)

   '--- Define power of 2 contants for bit shifting and masking

   c(7) = 128
   c(6) = 64
   c(5) = 32
   c(4) = 16
   c(3) = 8
   c(2) = 4
   c(1) = 2
   c(0) = 1


   '--- Define row,column coordinates for left and right zigzag patterns

   zl(0).Row = 0: zl(0).Col = 0
   zl(1).Row = 0: zl(1).Col = 1
   zl(2).Row = 1: zl(2).Col = 0
   zl(3).Row = 2: zl(3).Col = 0
   zl(4).Row = 1: zl(4).Col = 1
   zl(5).Row = 0: zl(5).Col = 2
   zl(6).Row = 0: zl(6).Col = 3
   zl(7).Row = 1: zl(7).Col = 2
   zl(8).Row = 2: zl(8).Col = 1
   zl(9).Row = 3: zl(9).Col = 0
   zl(10).Row = 4: zl(10).Col = 0
   zl(11).Row = 3: zl(11).Col = 1
   zl(12).Row = 2: zl(12).Col = 2
   zl(13).Row = 1: zl(13).Col = 3
   zl(14).Row = 0: zl(14).Col = 4
   zl(15).Row = 0: zl(15).Col = 5
   zl(16).Row = 1: zl(16).Col = 4
   zl(17).Row = 2: zl(17).Col = 3
   zl(18).Row = 3: zl(18).Col = 2
   zl(19).Row = 4: zl(19).Col = 1
   zl(20).Row = 5: zl(20).Col = 0
   zl(21).Row = 6: zl(21).Col = 0
   zl(22).Row = 5: zl(22).Col = 1
   zl(23).Row = 4: zl(23).Col = 2
   zl(24).Row = 3: zl(24).Col = 3
   zl(25).Row = 2: zl(25).Col = 4
   zl(26).Row = 1: zl(26).Col = 5
   zl(27).Row = 0: zl(27).Col = 6
   zl(28).Row = 0: zl(28).Col = 7
   zl(29).Row = 1: zl(29).Col = 6
   zl(30).Row = 2: zl(30).Col = 5
   zl(31).Row = 3: zl(31).Col = 4
   zl(32).Row = 4: zl(32).Col = 3
   zl(33).Row = 5: zl(33).Col = 2
   zl(34).Row = 6: zl(34).Col = 1
   zl(35).Row = 7: zl(35).Col = 0
   zl(36).Row = 7: zl(36).Col = 1
   zl(37).Row = 6: zl(37).Col = 2
   zl(38).Row = 5: zl(38).Col = 3
   zl(39).Row = 4: zl(39).Col = 4
   zl(40).Row = 3: zl(40).Col = 5
   zl(41).Row = 2: zl(41).Col = 6
   zl(42).Row = 1: zl(42).Col = 7
   zl(43).Row = 2: zl(43).Col = 7
   zl(44).Row = 3: zl(44).Col = 6
   zl(45).Row = 4: zl(45).Col = 5
   zl(46).Row = 5: zl(46).Col = 4
   zl(47).Row = 6: zl(47).Col = 3
   zl(48).Row = 7: zl(48).Col = 2
   zl(49).Row = 7: zl(49).Col = 3
   zl(50).Row = 6: zl(50).Col = 4
   zl(51).Row = 5: zl(51).Col = 5
   zl(52).Row = 4: zl(52).Col = 6
   zl(53).Row = 3: zl(53).Col = 7
   zl(54).Row = 4: zl(54).Col = 7
   zl(55).Row = 5: zl(55).Col = 6
   zl(56).Row = 6: zl(56).Col = 5
   zl(57).Row = 7: zl(57).Col = 4
   zl(58).Row = 7: zl(58).Col = 5
   zl(59).Row = 6: zl(59).Col = 6
   zl(60).Row = 5: zl(60).Col = 7
   zl(61).Row = 6: zl(61).Col = 7
   zl(62).Row = 7: zl(62).Col = 6
   zl(63).Row = 7: zl(63).Col = 7

   zr(0).Row = 0: zr(0).Col = 7
   zr(1).Row = 0: zr(1).Col = 6
   zr(2).Row = 1: zr(2).Col = 7
   zr(3).Row = 2: zr(3).Col = 7
   zr(4).Row = 1: zr(4).Col = 6
   zr(5).Row = 0: zr(5).Col = 5
   zr(6).Row = 0: zr(6).Col = 4
   zr(7).Row = 1: zr(7).Col = 5
   zr(8).Row = 2: zr(8).Col = 6
   zr(9).Row = 3: zr(9).Col = 7
   zr(10).Row = 4: zr(10).Col = 7
   zr(11).Row = 3: zr(11).Col = 6
   zr(12).Row = 2: zr(12).Col = 5
   zr(13).Row = 1: zr(13).Col = 4
   zr(14).Row = 0: zr(14).Col = 3
   zr(15).Row = 0: zr(15).Col = 2
   zr(16).Row = 1: zr(16).Col = 3
   zr(17).Row = 2: zr(17).Col = 4
   zr(18).Row = 3: zr(18).Col = 5
   zr(19).Row = 4: zr(19).Col = 6
   zr(20).Row = 5: zr(20).Col = 7
   zr(21).Row = 6: zr(21).Col = 7
   zr(22).Row = 5: zr(22).Col = 6
   zr(23).Row = 4: zr(23).Col = 5
   zr(24).Row = 3: zr(24).Col = 4
   zr(25).Row = 2: zr(25).Col = 3
   zr(26).Row = 1: zr(26).Col = 2
   zr(27).Row = 0: zr(27).Col = 1
   zr(28).Row = 0: zr(28).Col = 0
   zr(29).Row = 1: zr(29).Col = 1
   zr(30).Row = 2: zr(30).Col = 2
   zr(31).Row = 3: zr(31).Col = 3
   zr(32).Row = 4: zr(32).Col = 4
   zr(33).Row = 5: zr(33).Col = 5
   zr(34).Row = 6: zr(34).Col = 6
   zr(35).Row = 7: zr(35).Col = 7
   zr(36).Row = 7: zr(36).Col = 6
   zr(37).Row = 6: zr(37).Col = 5
   zr(38).Row = 5: zr(38).Col = 4
   zr(39).Row = 4: zr(39).Col = 3
   zr(40).Row = 3: zr(40).Col = 2
   zr(41).Row = 2: zr(41).Col = 1
   zr(42).Row = 1: zr(42).Col = 0
   zr(43).Row = 2: zr(43).Col = 0
   zr(44).Row = 3: zr(44).Col = 1
   zr(45).Row = 4: zr(45).Col = 2
   zr(46).Row = 5: zr(46).Col = 3
   zr(47).Row = 6: zr(47).Col = 4
   zr(48).Row = 7: zr(48).Col = 5
   zr(49).Row = 7: zr(49).Col = 4
   zr(50).Row = 6: zr(50).Col = 3
   zr(51).Row = 5: zr(51).Col = 2
   zr(52).Row = 4: zr(52).Col = 1
   zr(53).Row = 3: zr(53).Col = 0
   zr(54).Row = 4: zr(54).Col = 0
   zr(55).Row = 5: zr(55).Col = 1
   zr(56).Row = 6: zr(56).Col = 2
   zr(57).Row = 7: zr(57).Col = 3
   zr(58).Row = 7: zr(58).Col = 2
   zr(59).Row = 6: zr(59).Col = 1
   zr(60).Row = 5: zr(60).Col = 0
   zr(61).Row = 6: zr(61).Col = 0
   zr(62).Row = 7: zr(62).Col = 1
   zr(63).Row = 7: zr(63).Col = 0

   ULC = 1 + (X + 7) \ 8           'calculate image size in blocks
   ULR = 1 + (Y + 7) \ 8
   BWide = (XSize + 7) \ 8
   BHigh = (YSize + 7) \ 8
   IF (ULC + BWide) > 81 THEN BWide = 81 - ULC  'limit to 640x480 images
   IF (ULR + BHigh) > 61 THEN BHigh = 61 - ULR
   rsize& = BWide * BHigh * 32&
   XSize = (BWide * 8) - 1


   '--- Set up simulated BASIC-style pointers for direct memory access
   bcseg = VARSEG(BCodes(1))
   bcptr = VARPTR(BCodes(1))
   pcseg = VARSEG(PCodes(1))
   pcptr = VARPTR(PCodes(1))
   pelseg = VARSEG(Pixels(1))
   pelptr = VARPTR(Pixels(1))
   getseg = VARSEG(MoveBfr(1))

   lp = 0

   FOR i = 1 TO BHigh '-------------Main Compression Loop ---------------
      X = (ULC - 1) * 8
      CALL GMove4VE(ULC, Y, BWide, 8, getseg, 0)   'Capture portion of image
      CALL LineBF2VE(X, Y, X + XSize, Y + 7, 0)    'Clear the captured region
      getptr = VARPTR(MoveBfr(3))       'point to start of captured data
                                        '   first 2 elements are width & height
      FOR j = 1 TO BWide

         GOSUB GetBlk    'Read 8x8 block from capture buffer
         GOSUB CntColor  'Count colors in block

         '--- Lossy pre-processor (uses simple color substitution)
         IF Lossy THEN
            FOR k = 0 TO 6 STEP 2
               FOR l = 0 TO 6 STEP 2
                  IF pel(k, l) = pcolr THEN
                     pel(k, l + 1) = pcolr
                     pel(k + 1, l) = pcolr
                     pel(k + 1, l + 1) = pcolr
                  END IF
               NEXT l
            NEXT k
            GOSUB CntColor
         END IF
         '--- End Lossy pre-processor ------------------------------

         '--- Initialize pattern size parameters
         ts(0) = 64
         FOR k = 1 TO 6
            ts(k) = 16
            tp(k) = lp
         NEXT k
         IF nocolr < 9 THEN
            SELECT CASE nocolr
               CASE 2
                  ts(6) = nocolr + 16
               CASE 3, 4
                  ts(6) = nocolr + 32
               CASE IS > 4
                  ts(6) = nocolr + 48
            END SELECT
         ELSE
            ts(6) = 99
         END IF

         '--- Calculate Compressed Block Size for each pattern

         FOR k = 0 TO 7
            FOR l = 0 TO 7

               '--- Horiz. Run
               hr(k, l) = 0
               IF pel(k, l) <> tp(1) THEN
                  tp(1) = pel(k, l)
                  ts(1) = ts(1) + 1
                  hr(k, l) = 1
               END IF

               '--- Vert. Run
               vr(l, k) = 0
               IF pel(l, k) <> tp(2) THEN
                  tp(2) = pel(l, k)
                  ts(2) = ts(2) + 1
                  vr(l, k) = 1
               END IF

               '--- Prime Color
               pr(k, l) = 0
               IF pel(k, l) <> pcolr THEN
                  ts(3) = ts(3) + 1
                  pr(k, l) = 1
               END IF

            NEXT l
         NEXT k

         '--- ZigZag Patterns

         FOR k = 0 TO 63

            '--- Left
            lz(k) = 0
            IF pel(zl(k).Row, zl(k).Col) <> tp(4) THEN
               tp(4) = pel(zl(k).Row, zl(k).Col)
               ts(4) = ts(4) + 1
               lz(k) = 1
            END IF

            '--- Right
            rz(k) = 0
            IF pel(zr(k).Row, zr(k).Col) <> tp(5) THEN
               tp(5) = pel(zr(k).Row, zr(k).Col)
               ts(5) = ts(5) + 1
               rz(k) = 1
            END IF

         NEXT k

         '--- Select most efficient pattern
         FOR k = 1 TO 6
            IF ts(k) < ts(0) THEN
               ts(0) = ts(k)
               bc = k
            END IF
         NEXT k
         IF bc = 6 THEN bc = nocolr + 5

         GOSUB OutBC       'Output block compression code

         SELECT CASE bc    'Do encoding for selected block code
            CASE 0     'No compression
               noc = noc + 1
               FOR k = 0 TO 7
                  FOR l = 0 TO 7
                     p = pel(k, l)
                     GOSUB OutPel
                  NEXT l
               NEXT k

            CASE 1      'Horizontal run length
               hrc = hrc + 1
               FOR k = 0 TO 7
                  pc = 0
                  FOR l = 0 TO 7
                     IF hr(k, l) THEN
                        pc = pc OR c(7 - l)
                        p = pel(k, l)
                        GOSUB OutPel
                     END IF
                  NEXT l
                  GOSUB OutPC
               NEXT k

            CASE 2      'Vertical run length
               vrc = vrc + 1
               FOR k = 0 TO 7
                  pc = 0
                  FOR l = 0 TO 7
                     IF vr(l, k) THEN
                        pc = pc OR c(7 - l)
                        p = pel(l, k)
                        GOSUB OutPel
                     END IF
                  NEXT l
                  GOSUB OutPC
               NEXT k

            CASE 3      'Prime color
               pcc = pcc + 1
               p = pcolr
               GOSUB OutPel
               FOR k = 0 TO 7
                  pc = 0
                  FOR l = 0 TO 7
                     IF pr(k, l) THEN
                        pc = pc OR c(7 - l)
                        p = pel(k, l)
                        GOSUB OutPel
                     END IF
                  NEXT l
                  GOSUB OutPC
               NEXT k

            CASE 4      'Left zigzag
               zlc = zlc + 1
               pc = 0
               cnt = 7
               FOR k = 0 TO 63
                  IF lz(k) THEN
                     pc = pc OR c(cnt)
                     p = pel(zl(k).Row, zl(k).Col)
                     GOSUB OutPel
                  END IF
                  IF cnt = 0 THEN
                     GOSUB OutPC
                     cnt = 7
                     pc = 0
                  ELSE
                     cnt = cnt - 1
                  END IF
               NEXT k

            CASE 5      'Right zigzag
               zrc = zrc + 1
               pc = 0
               cnt = 7
               FOR k = 0 TO 63
                  IF rz(k) THEN
                     pc = pc OR c(cnt)
                     p = pel(zr(k).Row, zr(k).Col)
                     GOSUB OutPel
                  END IF
                  IF cnt = 0 THEN
                     GOSUB OutPC
                     cnt = 7
                     pc = 0
                  ELSE
                     cnt = cnt - 1
                  END IF
               NEXT k

            CASE 6        'Single color
               vlc = vlc + 1
               p = pel(0, 0)
               GOSUB OutPel

            CASE 7        'Two colors
               vlc = vlc + 1
               GOSUB OutColrs
               pcolr = lp
               FOR k = 0 TO 7
                  pc = 0
                  FOR l = 0 TO 7
                     p = pel(k, l)
                     IF p <> pcolr THEN pc = pc OR c(7 - l)
                  NEXT l
                  GOSUB OutPC
               NEXT k

            CASE 8, 9     '3,4 colors
               vlc = vlc + 1
               GOSUB OutColrs
               FOR k = 0 TO 7
                  pc1 = 0
                  pc2 = 0
                  FOR l = 0 TO 7
                     p = colr(pel(k, l), 1)
                     IF p AND 1 THEN pc1 = pc1 OR c(7 - l)
                     IF p AND 2 THEN pc2 = pc2 OR c(7 - l)
                  NEXT l
                  pc = pc1
                  GOSUB OutPC
                  pc = pc2
                  GOSUB OutPC
               NEXT k

            CASE IS > 9    '5 to 8 colors
               vlc = vlc + 1
               GOSUB OutColrs
               FOR k = 0 TO 7
                  pc1 = 0
                  pc2 = 0
                  pc3 = 0
                  FOR l = 0 TO 7
                     p = colr(pel(k, l), 1)
                     IF p AND 1 THEN pc1 = pc1 OR c(7 - l)
                     IF p AND 2 THEN pc2 = pc2 OR c(7 - l)
                     IF p AND 4 THEN pc3 = pc3 OR c(7 - l)
                  NEXT l
                  pc = pc1
                  GOSUB OutPC
                  pc = pc2
                  GOSUB OutPC
                  pc = pc3
                  GOSUB OutPC
               NEXT k
         END SELECT
         X = X + 8          'Point to next block
      NEXT j
      Y = Y + 8             'Point to next region
      IF (plt& > 65500) OR (pct& > 65500) THEN      'out of bounds condition
         csize& = -1                                'set error indicator
         EXIT SUB                                   'Abort
      END IF
   NEXT i           '--- End Main Compression loop ------------------------


   '--- flush output buffers if necessary
   IF pelflg THEN GOSUB OutPel
   IF bcflg THEN GOSUB OutBC

   PRINT "Please wait ... ";

   '--- Use 1-D coding to further shrink data arrays
   NoBlk = 0
   CALL ShrinkArray(VARSEG(BCodes(1)), VARPTR(BCodes(1)), bct&, NoBlk)
   BCodes(0) = NoBlk
   bct& = bct& + 2
   CALL ShrinkArray(VARSEG(PCodes(1)), VARPTR(PCodes(1)), pct&, NoBlk)
   PCodes(0) = NoBlk
   pct& = pct& + 2
   CALL ShrinkArray(VARSEG(Pixels(1)), VARPTR(Pixels(1)), plt&, NoBlk)
   Pixels(0) = NoBlk
   plt& = plt& + 2
   csize& = 68 + plt& + pct& + bct&     'calculate compressed size + header
   DEF SEG    'restore BASIC's default segment pointer

EXIT SUB     '--- End the subprogram



'--- GOSUB's for code blocks using common data

GetBlk:
   FOR k = 0 TO 15
      colr(k, 0) = 0: colr(k, 1) = 0
   NEXT k
   tmpptr = getptr
   DEF SEG = getseg
   FOR k = 0 TO 7
      pb1 = 0: pb2 = 0: pb3 = 0: pb4 = 0
      pb1 = PEEK(tmpptr)
      tmpptr = tmpptr + BWide
      pb2 = PEEK(tmpptr)
      tmpptr = tmpptr + BWide
      pb3 = PEEK(tmpptr)
      tmpptr = tmpptr + BWide
      pb4 = PEEK(tmpptr)
      tmpptr = tmpptr + BWide
      FOR l = 0 TO 7
         t = 7 - l
         p = ((pb1 AND c(t)) + (pb2 AND c(t)) * 2 + (pb3 AND c(t)) * 4 + (pb4 AND c(t)) * 8) \ c(t)
         pel(k, l) = p
         colr(p, 0) = colr(p, 0) + 1
      NEXT l
   NEXT k
   getptr = getptr + 1
RETURN


CntColor:
   nocolr = 0
   maxcolr = 0
   pcolr = 0
   bc = 0
   FOR k = 0 TO 15
      IF colr(k, 0) THEN
         IF colr(k, 0) > maxcolr THEN
            maxcolr = colr(k, 0)
            pcolr = k
         END IF
         colr(k, 1) = nocolr
         nocolr = nocolr + 1
      END IF
   NEXT k
RETURN


OutPC:                 'pattern code output
   DEF SEG = pcseg     'select segment
   POKE pcptr, pc      'write pattern byte to pointer location
   pcptr = pcptr + 1   'point to next location
   pct& = pct& + 1     'count the byte
RETURN                 'go back for more


OutPel:                'Buffered color coefficient output to pixel array
   IF pelflg THEN
      pb = pb OR p
      DEF SEG = pelseg
      POKE pelptr, pb
      pelptr = pelptr + 1
      pelflg = 0
      lp = p
      plt& = plt& + 1
   ELSE
      pb = p * 16
      pelflg = -1
      lp = p
   END IF
RETURN


OutBC:                'Buffered block compression code output
   IF bcflg THEN
      bcb = bcb OR bc
      DEF SEG = bcseg
      POKE bcptr, bcb
      bcptr = bcptr + 1
      bcflg = 0
      bct& = bct& + 1
   ELSE
      bcb = bc * 16
      bcflg = -1
   END IF
RETURN


OutColrs:                 'Output color coefficients in order
   FOR k = 0 TO 15        '   for variable length coding
      IF colr(k, 0) THEN
         p = k
         GOSUB OutPel
      END IF
   NEXT k
RETURN

END SUB


SUB SaveABC (FileOut$, XSize, YSize) 'File save routine

   DIM ABCHdr AS STRING * 20

   MID$(ABCHdr, 1) = CHR$(237)       'signature byte = EDh
   MID$(ABCHdr, 2) = CHR$(20)        'header size in bytes
   MID$(ABCHdr, 3) = MKI$(XSize)     'original image width in pixels
   MID$(ABCHdr, 5) = MKI$(YSize)     'original image height in pixels
   MID$(ABCHdr, 7) = CHR$(12)        'screen mode in hex
   MID$(ABCHdr, 8) = CHR$(4)         'bits per pixel
   MID$(ABCHdr, 9) = CHR$(48)        'palette size in bytes
   MID$(ABCHdr, 10) = CHR$(0)        '       "
   MID$(ABCHdr, 11) = MKI$(bct&)     'block code size in bytes
   MID$(ABCHdr, 13) = MKL$(pct&)     'pattern code size in bytes
   MID$(ABCHdr, 17) = MKL$(plt&)     'color coefficients in bytes

   KILL FileOut$                     'kill file
   FileNum = FREEFILE                'get next available BASIC file number
   OPEN FileOut$ FOR BINARY AS #FileNum
      PUT FileNum, , ABCHdr
      FOR k = 0 TO 15
         CALL GetPalTripleVGA(k, r, g, b)
         t$ = CHR$(r) + CHR$(g) + CHR$(b)
         PUT FileNum, , t$             'output image palette
      NEXT k
      CALL BlkPut(FileNum, VARSEG(BCodes(0)), VARPTR(BCodes(0)), bct&)
      CALL BlkPut(FileNum, VARSEG(PCodes(0)), VARPTR(PCodes(0)), pct&)
      CALL BlkPut(FileNum, VARSEG(Pixels(0)), VARPTR(Pixels(0)), plt&)
   CLOSE FileNum

END SUB


SUB ShrinkArray (BYVAL inseg, BYVAL inptr, bytesz&, NoBlk)

'--- 1-D block coding to shrink an array

   REDIM CBlk(15)
   REDIM runlen(15)
   REDIM primechr(15)
   REDIM CCnt(255)
   REDIM OutBfr(32766)
   REDIM SCodes(1024)
   REDIM CCodes(4096)

   noc = 16
   scnt = 7
   scb = 0
   outseg = VARSEG(OutBfr(1))
   outptr = VARPTR(OutBfr(1))
   scseg = VARSEG(SCodes(1))
   scptr = VARPTR(SCodes(1))
   ccseg = VARSEG(CCodes(1))
   ccptr = VARPTR(CCodes(1))
   getptr = inptr
   NoBlk = (bytesz& + 15) \ 16
   lc = 0

   FOR j = 1 TO NoBlk
      GOSUB GetCBlk
      GOSUB GetSC
      GOSUB ShrinkBlk
   NEXT j

   IF scnt < 7 THEN GOSUB OutSC
   scsz = scsz + 2
   ccsz = ccsz + 2
   otsz = otsz + 2
   outsz& = otsz + scsz + ccsz
   IF outsz& < bytesz& THEN   'copy compressed data back into input array
      OutBfr(0) = otsz
      SCodes(0) = scsz
      CCodes(0) = ccsz
      bytesz& = outsz&
      getptr = inptr
      scptr = VARPTR(SCodes(0))
      ccptr = VARPTR(CCodes(0))
      outptr = VARPTR(OutBfr(0))
      CALL BlockCopy(scseg, scptr, inseg, getptr, scsz)
      getptr = getptr + scsz
      CALL BlockCopy(ccseg, ccptr, inseg, getptr, ccsz)
      getptr = getptr + ccsz
      CALL BlockCopy(outseg, outptr, inseg, getptr, otsz)
   ELSE
      NoBlk = 0
   END IF
EXIT SUB


GetCBlk:
   DEF SEG = inseg
   FOR k = 0 TO 15
      CBlk(k) = PEEK(getptr)
      getptr = getptr + 1
      CCnt(CBlk(k)) = CCnt(CBlk(k)) + 1
   NEXT k
   nopr = 0
   prchr = 0
   FOR k = 0 TO 15
      IF CCnt(CBlk(k)) > nopr THEN
         prchr = CBlk(k)
         nopr = CCnt(CBlk(k))
      END IF
      CCnt(CBlk(k)) = 0
   NEXT
RETURN


GetSC:
   '--- Run Length
   rlc = 2
   tlc = lc
   FOR k = 0 TO 15
      runlen(k) = 0
      IF CBlk(k) <> tlc THEN
         runlen(k) = 1
         tlc = CBlk(k)
         rlc = rlc + 1
      END IF
   NEXT k

   '--- Prime char.
   prc = 3
   FOR k = 0 TO 15
      primechr(k) = 0
      IF CBlk(k) <> prchr THEN
         primechr(k) = 1
         prc = prc + 1
      END IF
   NEXT k

   tc = noc                  'select most efficient pattern
   sc = 0
   IF rlc < tc THEN
      sc = 1
      tc = rlc
   END IF
   IF prc < tc THEN
      sc = 2
      tc = prc
   END IF
RETURN


ShrinkBlk:       'perform the actual encoding of the block
   IF sc AND 1 THEN scb = scb OR c(scnt)
   IF sc AND 2 THEN scb = scb OR c(scnt - 1)
   scnt = scnt - 2
   IF scnt < 0 THEN GOSUB OutSC
   SELECT CASE sc
      CASE 0          'no compression
         DEF SEG = outseg
         FOR k = 0 TO 15
            POKE outptr, CBlk(k)
            outptr = outptr + 1
         NEXT k
         otsz = otsz + 16
         lc = CBlk(15)
      CASE 1         'run length
         FOR k = 0 TO 7
            IF runlen(k) THEN
               cc1 = cc1 OR c(7 - k)
               ch = CBlk(k)
               GOSUB OutCh
            END IF
         NEXT k
         FOR k = 8 TO 15
            IF runlen(k) THEN
               cc2 = cc2 OR c(15 - k)
               ch = CBlk(k)
               GOSUB OutCh
            END IF
         NEXT k
         GOSUB OutCC
      CASE 2        'prime character/byte
         ch = prchr
         GOSUB OutCh
         FOR k = 0 TO 7
            IF primechr(k) THEN
               cc1 = cc1 OR c(7 - k)
               ch = CBlk(k)
               GOSUB OutCh
            END IF
         NEXT k
         FOR k = 8 TO 15
            IF primechr(k) THEN
               cc2 = cc2 OR c(15 - k)
               ch = CBlk(k)
               GOSUB OutCh
            END IF
         NEXT k
         GOSUB OutCC
   END SELECT
RETURN

OutSC:                  'output block/shrink code
   DEF SEG = scseg
   POKE scptr, scb
   scptr = scptr + 1
   scsz = scsz + 1
   scb = 0
   scnt = 7
RETURN

OutCC:                  'output character/pattern code
   DEF SEG = ccseg
   POKE ccptr, cc1
   ccptr = ccptr + 1
   POKE ccptr, cc2
   ccptr = ccptr + 1
   ccsz = ccsz + 2
   cc1 = 0
   cc2 = 0
RETURN

OutCh:                   'output character/byte coefficient
   DEF SEG = outseg
   POKE outptr, ch
   outptr = outptr + 1
   otsz = otsz + 1
   lc = ch
RETURN

END SUB

