;*********************************************************************
; CGATEVXD.ASM - Call Gate Virtual Device
; by Alex Shmidt. Nov, 1993
;*********************************************************************
.386p
.xlist
        include vmm.inc
        include v86mmgr.inc
        include dosmgr.inc
        include int2fapi.inc
        include shell.inc
        include debug.inc
        include cgatevxd.inc
.list

if1
 ifdef DEBUG
   %out  Debugging version
 endif
 ifdef WINICE
   %out  SOFT-ICE/W version
 endif
endif

Declare_Virtual_Device CGATE, 1, 0, CGATE_Control, Undefined_Device_ID, \
                       Undefined_Init_Order

VxD_IDATA_SEG
VxD_IDATA_ENDS

VxD_DATA_SEG
CALLGATE32      dw      0               ; callgate GDT selector
VXD_FIRST       dd      0               ; pointer to VMM_DDB
OLD_2F_OFFSET   dd      0
OLD_2F_SEL      dw      0
GATENAME        db      'CallGate',0
VxD_DATA_ENDS

VxD_LOCKED_CODE_SEG
Begin_Control_Dispatch CGATE
        Control_Dispatch Sys_Critical_Init, CGATE_Sys_Critical_Init
End_Control_Dispatch CGATE
VxD_LOCKED_CODE_ENDS

VxD_ICODE_SEG

BeginProc       CGATE_Sys_Critical_Init
        mov     ax, 2fh
        VMMCall Get_PM_Int_Vector
        mov     [OLD_2F_OFFSET],edx
        mov     [OLD_2F_SEL],cx
        mov     esi, offset32 CGate_2F_Handler
        VMMCall Allocate_PM_Call_Back
        movzx   edx, ax
        shr     eax, 16
        mov     ecx, eax
        mov     ax, 2fh
        VMMCall Set_PM_Int_Vector
        clc
        ret
EndProc         CGATE_Sys_Critical_Init

VxD_ICODE_ENDS

VxD_CODE_SEG
Private_JmpTable        label   dword
dd      offset32 CreateGDTCallGate
dd      offset32 DestroyGDTCallGate

BeginProc       CGate_2F_Handler
        cmp     [ebp].Client_AX, 168Ah
        je      short @f
dispatch_2f:
        mov     edx,[OLD_2F_OFFSET]
        mov     cx,[OLD_2F_SEL]
        VMMCall Simulate_Far_Jmp
finish_2f:
        clc
        ret
@@:
        Client_Ptr_Flat edi, ds, si
        mov     esi, offset32 GATENAME
        cld
@@:
        cmpsb
        jnz     short dispatch_2f
        cmp     byte ptr [edi-1], 0
        jnz     short @b
        VMMcall Simulate_Iret
        movzx   eax,[ebp].CLient_DX
        cmp     eax,LAST_PRIVATE
        ja      short @f
        call    dword ptr Private_JmpTable[eax*4]
@@:
        jmp     short finish_2f
EndProc         CGate_2F_Handler

;Client_ES:DI -> ring3 function
;Client_CL = # of params
;       returns Client_DX = callgate
BeginProc       CreateGDTCallGate
        movzx   ecx, [ebp].Client_CL
        or      cx, GATE32_RING3
        Client_Ptr_Flat edx,es,di
        mov     [ebp].Client_CX,dx
        ror     edx,16
        mov     [ebp].Client_BX,dx
        ror     edx,16
        mov     ax, cs
        call    BuildCallGate
        VMMCall _Allocate_GDT_Selector,<edx,eax,20000000h>
        mov     [ebp].Client_DX,ax
        mov     [ebp].Client_AX,0
        ret
EndProc         CreateGDTCallGate

;client_cx = cgate to destroy
BeginProc       DestroyGDTCallGate
        movzx   eax,[ebp].Client_CX
        VMMCall _Free_GDT_Selector,<eax,0>
        ret
EndProc         DestroyGDTCallGate

;       On Entry:       ax  = Gate Selector
;                       edx = Gate Offset
;                       cx  = gate type | Dword Count
;
;       returns:        edx = hi desc dword
;                       eax = lo dess dword
BeginProc       BuildCallGate
        movzx   eax, ax
        shl     eax, 16
        mov     ax, dx
        mov     dx, cx
        ret
EndProc         BuildCallGate

VxD_CODE_ENDS
        end
