PUBLIC               IOCTL_OUT
PUBLIC               IOCTL_IN
include  extasm.inc
DGROUP               GROUP   _DATA

IO_SIZE         equ   32

_DATA   SEGMENT PUBLIC  'DATA'

;io_string          db  IO_SIZE dup(0)
io_string          db  '1',0
                   db  14 dup(0)
_DATA   ENDS

_TEXT   SEGMENT 'CODE'
             ASSUME cs:_TEXT, ds:DGROUP

;---------------------ioctl_out--------------------------------
;; This routine is similar the basic IOCTL output routine
;; called from CLIPPER as IOCTL_OUT(nHandle, szRegisterCommand)



IOCTL_OUT  PROC    FAR

             push    bp              ; Save registers
             mov     bp,sp
             push    ds
             push    es
             push    si
             push    di

        ;;perform a DOS int 44 to perform ioctl
        ;; deref parms

             mov        ax,0
             push       ax  
             call       __parinfo 
             add        sp,2
             cmp        ax, 2
             jnz        io_x

        ;; if two parms get the handle as 1, command reg as 2

             mov        ax, 1
             push       ax
             call       __parni
             add        sp,2
             push       ax              ; save handle on stack

             mov        ax, 2
             push       ax
             call       __parc
             add        sp,2            ; DX:AX has pointer to string

             push       ax
             push       dx              ; save on stack

             mov        ax, 2
             push       ax
             call       __parclen
             add        sp,2
             mov        cx, ax          ; count of bytes

        ;; do it
             pop        ds
             pop        dx              ; ds:dx point at string

             pop        bx              ; bx has handle
             mov        ax,4403H        ; ioctl write data

             int        21h
            

io_x:
             pop     di              ; Restore registers
             pop     si
             pop     es
             pop     ds
             pop     bp
             ret        

IOCTL_OUT    ENDP                    ; End of routine

;----------------------------ioctl_in--------------------------------
;; Read a control string from a device driver
;; This routine is similar to the BASIC IOCTl$() call
;; To call from CLIPPER us szString = IOCTL_IN(nHandle)

IOCTL_IN     PROC    FAR

             push    bp              ; Save registers
             mov     bp,sp
             push    ds
             push    es
             push    si
             push    di

        ;; use DOS int 21H IOCTL function 44 to read a control string

             mov        ax,0
             push       ax  
             call       __parinfo 
             add        sp,2
             cmp        ax, 1
             jnz        io_xx

        ;; if two parms get the handle as 1, command reg as 2

             mov        ax, 1
             push       ax
             call       __parni
             add        sp,2

             mov        bx, ax          ; handle
             push       ds
             mov        ax, _DATA
             mov        ds, ax
             mov        ax, 4402H       ; read ioctl string
             mov        dx, offset io_string
             mov        cx, IO_SIZE  

             int        21H
                                        ; ds:dx has string ax has bytes
             pop        ds

             ; try a null terminated
        
             mov        dx, offset io_string
             mov        ax, _DATA
             push       ax              ; segment
             push       dx              ; offset
             call       __retc
             add        sp, 4           ; 3 words

;;             push       ax              ; number of bytes
;;             mov        ax, DGROUP
;;             push       ax              ; segment
;;             push       dx              ; offset
;;             call       __retclen
;;             add        sp, 6           ; 3 words
io_xx:
             pop     di              ; Restore registers
             pop     si
             pop     es
             pop     ds
             pop     bp
             ret
IOCTL_IN     ENDP                    ; End of routine


_TEXT        ENDS                    ; End of code segment
             END


