/*
  C source for Winsock Chess
  
  Revision 1994-03-15
  Modified by Donald Munro for use as a 2 player chess game over a 
  WINSOCK layer on a TCP (or other WinSock supporting) network.
  Source code and make files for MS Visual C/C++ V1.00/1.50.
  February/March 1994
  All GNU copyright and distribution conditions as described below and in the
  file COPYING also apply to WinSock Chess.
  This module is adapted from GNU Chess.
  
  C source for GNU CHESS

  Revision: 1990-09-30

  Modified by Daryl Baker for use in MS WINDOWS environment

  This file is part of CHESS.

  CHESS is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY.  No author or distributor accepts responsibility to anyone for
  the consequences of using it or for whether it serves any particular
  purpose or works at all, unless he says so in writing.  Refer to the CHESS
  General Public License for full details.

  Everyone is granted permission to copy, modify and redistribute CHESS, but
  only under the conditions described in the CHESS General Public License.
  A copy of this license is supposed to have been given to you along with
  CHESS so you can know your rights and responsibilities.  It should be in a
  file named COPYING.  Among other things, the copyright notice and this
  notice must be preserved on all copies.
*/

#define NOATOM 
#define NOCLIPBOARD
#define NOCREATESTRUCT
#define NOFONT
#define NOREGION
#define NOSOUND
#define NOWH
#define NOWINOFFSETS
#define NOCOMM
#define NOKANJI

#include <windows.h>
#include "timecnt.h"
#include "chess.h"

extern int TCmoves, TCminutes, TCflag;

static int tmpTCmoves;
static int tmpTCminutes;

/* Changed by DM - Used to use CheckRadioButton on non-contiguos control ids 
   which causes intermittent protection faults and hangs (see Petzold plus
   debug kernal output).
   Changed timecnt.h to not use non-contiguos ids for the radio buttons and
   added functions GetMoves and GetMinutes etc - there's probably a more 
   elegant way of doing this but this was a quickfix. */

int GetMoves(WPARAM id)
//---------------------
{ switch (id)
   { case TMDLG_60MOV :
        return 60;
     case TMDLG_40MOV :
        return 40;
     case TMDLG_20MOV :
        return 20;
     case TMDLG_10MOV :
        return 10;
     case TMDLG_1MOV :
        return 1;
    }
  return 40;
}        
        
int GetMinutes(WPARAM id)
//-----------------------
{ switch (id)
   { case TMDLG_600MIN :
        return 600;
     case TMDLG_60MIN  :
        return 60;
     case TMDLG_30MIN  :
        return 30;
     case TMDLG_15MIN  :
        return 15;    
     case TMDLG_5MIN   :
        return 5;
    }
  return 60;
}        

int GetMinutesId(int nMinutes)
//----------------------------
{ switch (nMinutes)
   { case 600 :
        return TMDLG_600MIN;
     case 60 :
        return TMDLG_60MIN;
     case 30 :
        return TMDLG_30MIN;
     case 15 :
        return TMDLG_15MIN;
     case 5 :
        return TMDLG_5MIN;
    }
  return TMDLG_60MIN;
}        

int GetMovesId(int nMoves)
//------------------------
{ switch (nMoves)
   { case 60 :
        return TMDLG_60MOV;
     case 40 :
        return TMDLG_40MOV;
     case 20 :
        return TMDLG_20MOV;
     case 10 :
        return TMDLG_10MOV;
     case 1 :
        return TMDLG_1MOV;
    }
  return TMDLG_40MOV;
}        

BOOL CALLBACK TimeControlDlgProc ( HWND hDlg, UINT message,WPARAM wParam, 
                                   LPARAM lParam)
//-----------------------------------------------------------------------                                   
{

   switch (message) {
       case WM_INITDIALOG:     
         tmpTCminutes = GetMinutesId(TCminutes);
         tmpTCmoves   = GetMovesId(TCmoves);;
         CheckRadioButton ( hDlg, TMDLG_1MOV, TMDLG_60MOV, tmpTCmoves);
         CheckRadioButton ( hDlg, TMDLG_5MIN, TMDLG_600MIN, tmpTCminutes);
         tmpTCminutes = TCminutes;
         tmpTCmoves   = TCmoves;
         return (TRUE);

      case WM_SYSCOMMAND:
         if ( (wParam&0xfff0) == SC_CLOSE ) {
              EndDialog(hDlg, NULL);
              return TRUE;
         }
         break;


       case WM_COMMAND:    
         switch (wParam) {
         
            case IDOK:
               TCminutes = tmpTCminutes;
               TCmoves   = tmpTCmoves;
               EndDialog(hDlg, 1);
               return TRUE;
               break;

             case IDCANCEL:
              EndDialog(hDlg, NULL);
              return TRUE;
               break;

            case TMDLG_1MOV:
            case TMDLG_10MOV:
            case TMDLG_20MOV:
            case TMDLG_40MOV:
            case TMDLG_60MOV:
                  // tmpTCmoves = wParam - TMDLG_MOV;       
                  tmpTCmoves = GetMoves(wParam);
                  CheckRadioButton ( hDlg, TMDLG_1MOV, TMDLG_60MOV, wParam);
                  break;

            case TMDLG_5MIN:
            case TMDLG_15MIN:
            case TMDLG_30MIN:
            case TMDLG_60MIN:
            case TMDLG_600MIN:
                  // tmpTCminutes = wParam - TMDLG_MIN;
                  tmpTCminutes = GetMinutes(wParam);
                  CheckRadioButton ( hDlg, TMDLG_5MIN, TMDLG_600MIN, wParam);
                  break;
         }
          break;
    }

    return (FALSE);               /* Didn't process a message    */
}


int TimeControlDialog ( HWND hWnd, HANDLE hInst, DWORD Param )
{ int status;

   status = DialogBoxParam (hInst,(LPCSTR)"TIMECNT",hWnd,
                            TimeControlDlgProc, (LPARAM)Param);
   return status;
}



