/***********************************************************************
**
** TIMEDLG.CPP
**
** Copyright 1994 by Ewan Kirk <ewan@kirk.demon.co.uk>
**
** Permission to use, copy, modify, distribute, and sell this software and its
** documentation for any purpose is hereby granted without fee, provided that
** the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of Ewan Kirk not be used in
** advertising or publicity pertaining to distribution of the software without
** specific, written prior permission.  Ewan Kirk makes no representations
** about the suitability of this software for any purpose.  It is provided
** "as is" without express or implied warranty.
**
** EWAN KIRK DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
** INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
** EVENT SHALL EWAN KIRK BE LIABLE FOR ANY SPECIAL, INDIRECT OR
** CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
** DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
** TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
** PERFORMANCE OF THIS SOFTWARE.
**
** This file is part of WINDIS. 
**
** TimeDlg.  Just handles the wee time dialog that pops up.
** No reason for it to be in its own file really.  Nice
** for testing the Socket stuff though.
**
** V1.0 - Initial Revision 01-Sep-94
**
*/
// timedlg.cpp : implementation file
//

#include "stdafx.h"
#include <dos.h>
#include "windis.h"
#include "utility.h"
#include "csocket.h"
#include "timedlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTimeDlg dialog
                                
CTimeDlg::CTimeDlg(BOOL Simple, const char * Host , CWnd * pParent )
	: CDialog( IDD , pParent ) , m_Flag( Simple ) , m_Sock( NULL ) , m_Host( Host )
{
	//{{AFX_DATA_INIT(CTimeDlg)
	//}}AFX_DATA_INIT
	m_time = m_localtime = 0;
	m_Log = AllocateLogger( "time" );
}

CTimeDlg::~CTimeDlg()
{
	delete m_Sock;
	delete m_Log;
}
              
              
void CTimeDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTimeDlg)
	DDX_Control(pDX, IDC_TIME_LOCALTIME, m_LocalTime);
	DDX_Control(pDX, IDC_TIME_CANCEL, m_Button);
	DDX_Control(pDX, IDC_TIME_PROGRESS, m_Progress);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CTimeDlg, CDialog)
	//{{AFX_MSG_MAP(CTimeDlg)
	ON_BN_CLICKED(IDC_TIME_CANCEL, OnClickedTimeCancel)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


// The Socket Handlers
void CTimeDlg:: ReadTime( time_t Time )
{                            
	CString Buffer = "";
	m_time = Time;	

	// Get the current time zone and put it into the environment
	CString Tz = "TZ=";
	Tz += gConfig->GetTimeZone();
	_putenv(Tz);
	ASSERT( strcmp( getenv( "TZ" ) , gConfig->GetTimeZone() ) == 0 );
	// Now set the tz variables with the time zone;
	_tzset();                                      
	m_localtime = m_time + _timezone;
		
	Buffer = asctime( gmtime( &m_time ) );
	// Nuke CR
	Buffer = Buffer.Left( Buffer.GetLength() - 1 );
	Buffer += " (GMT)";                     
	m_Progress.SetWindowText( Buffer );

	struct tm * LocalTime = localtime( &m_time );
	Buffer = asctime( LocalTime );
	Buffer += " (Loc)";
	m_LocalTime.SetWindowText( Buffer );
	
	if( gConfig->GetTimeSetSystem() )
	{
		// Let's set the system time
#ifdef WIN32
		// NT Code by 
		// Colin Spensley <colin@alecto.demon.co.uk>
		// 09 Nov 94

                SYSTEMTIME NT_Time;
                struct tm *ReceivedTime = gmtime(&m_time);
                GetSystemTime(&NT_Time);
                NT_Time.wHour = (WORD) ReceivedTime->tm_hour;
                NT_Time.wMinute = (WORD) ReceivedTime->tm_min;
                NT_Time.wSecond = (WORD) ReceivedTime->tm_sec;
                NT_Time.wMilliseconds = (WORD) 0;//ReceivedTime->tm_sec;
                NT_Time.wDay = (WORD) ReceivedTime->tm_mday;
                NT_Time.wMonth = (WORD) (ReceivedTime->tm_mon + 1);
                NT_Time.wYear = (WORD) (ReceivedTime->tm_year + 1900);
                NT_Time.wDayOfWeek = (WORD) ReceivedTime->tm_wday;
                SetSystemTime(&NT_Time);
#else

		struct _dostime_t DosTime;
		struct _dosdate_t DosDate;
		DosTime.hour = (unsigned char)LocalTime->tm_hour;
		DosTime.minute = (unsigned char)LocalTime->tm_min;
		DosTime.second = (unsigned char)LocalTime->tm_sec;
		DosTime.hsecond = 0;
		DosDate.day = (unsigned char)LocalTime->tm_mday;
		DosDate.month = (unsigned char)(LocalTime->tm_mon + 1); // 1 = jan;
		DosDate.dayofweek = (unsigned char)LocalTime->tm_wday;
		DosDate.year = (unsigned int)LocalTime->tm_year + 1900;
		
		_dos_settime( &DosTime );
		_dos_setdate( &DosDate );
		::SendMessage( HWND_BROADCAST , WM_TIMECHANGE , 0 , 0 );
#endif
	}
		
	if( m_Flag )
		m_Button.SetWindowText( "Ok" );
	else
		EndDialog( IDOK );
}

void CTimeDlg::Connected( int Error, tcSocket * Sock )
{                                                    
	ASSERT( m_Sock == Sock ); 
	Sock->ClrTimeout();
	if( Error == 0 )
	{
		m_Progress.SetWindowText( "Connected" );
	}
	else
		SocketError( Sock , Error );
}	
	
void CTimeDlg::Timeout( tcSocket * Sock )
{                            
	 ASSERT( m_Sock == Sock );
	 m_Progress.SetWindowText( "Timeout" );
}

void CTimeDlg::Closed( int  , tcSocket * Sock )
{                                
	ASSERT( Sock == m_Sock );
}

void CTimeDlg::OnClickedTimeCancel()
{
	// TODO: Add your control notification handler code here
	CString Text;
	m_Button.GetWindowText( Text );
	BOOL Cancel = ( Text == "Cancel" );
	
	if( m_Flag )
	{   
		Cancel? EndDialog( IDCANCEL ): EndDialog( IDOK );
	}
	else
	{	
		EndDialog( IDCANCEL );
	}
}

BOOL CTimeDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	BOOL CloseMe = FALSE;

	char Buffer[ 128 ];
    
	m_Sock = new CTimeSocket( m_Log , this );
	wsprintf( Buffer , "Connecting to %s" , (const char *)m_Host );
	m_Progress.SetWindowText( Buffer );
	if ( m_Sock->Connect( (const char *)m_Host , 37 ) < 0 )
	{                                  
		m_Progress.SetWindowText( "Connect Returned Error " );
		m_Sock->Close();
		if( m_Flag )
		{   // This is a simple dialog box so we ask the user to close it
			m_Button.SetWindowText( "Cancel" );
		}
		else
		{	// This is a pop up which we're going to close anyway	
			EndDialog( IDCANCEL );
		}
	}
	else
	{
		m_Sock->SetTimeout( TIMEOUT_CONNECT , TO_CONNECTING );
		m_Button.SetWindowText( "Cancel" );
	}

	return TRUE;  // return TRUE  unless you set the focus to a control
}

