/***********************************************************************
**
** SERVSOCK.CPP
**
** Copyright 1994 by Ewan Kirk <ewan@kirk.demon.co.uk>
**
** Permission to use, copy, modify, distribute, and sell this software and its
** documentation for any purpose is hereby granted without fee, provided that
** the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of Ewan Kirk not be used in
** advertising or publicity pertaining to distribution of the software without
** specific, written prior permission.  Ewan Kirk makes no representations
** about the suitability of this software for any purpose.  It is provided
** "as is" without express or implied warranty.
**
** EWAN KIRK DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
** INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
** EVENT SHALL EWAN KIRK BE LIABLE FOR ANY SPECIAL, INDIRECT OR
** CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
** DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
** TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
** PERFORMANCE OF THIS SOFTWARE.
**
** This file is part of WINDIS. 
**
** This is the Server socket implementation.  This socket handles
** **all** the interaction with other clients.  It can be
** multiply instantiated and does the whole lot sending messages
** to its user interface parent.
**
** Could be cleverer and could handle different ways of
** storing the mail messages (see CMailMessage).
**
** V1.0 - Initial Revision 01-Sep-94
**
*/
////////////////////////////////////////////////////////////////////
// nntpsock.cpp
// Implementation of the nntpclient socket
#include "stdafx.h"
#include "windis.h"
#include "utility.h"
#include "tcsock.h"
#include "csocket.h"
#include "servsock.h"                  
#include "servdlg.h"

class CServParseTable {
  public:
	const char * Str;
	CServSocket::servCommands Cmd; 
};



CServParseTable ParseTable[] = {
	{ "HELO" , CServSocket::HELO },
	{ "EHLO" , CServSocket::EHLO },
	{ "RCPT" , CServSocket::RCPT },
	{ "DATA" , CServSocket::DATA },
	{ "RSET" , CServSocket::RSET },
	{ "SEND" , CServSocket::SEND },
	{ "SOML" , CServSocket::SOML },
	{ "SAML" , CServSocket::SAML },
	{ "MAIL" , CServSocket::MAIL },
	{ "VRFY" , CServSocket::VRFY },
	{ "EXPN" , CServSocket::EXPN },
	{ "HELP" , CServSocket::HELP },
	{ "NOOP" , CServSocket::NOOP },
	{ "QUIT" , CServSocket::QUIT },
	{ "TURN" , CServSocket::TURN },              
	{ ""     , CServSocket::SERVERROR }
};

// The simple inline constructors for the time Socket
CServSocket::CServSocket( tcLogger * Log , CServDlg * pParent , int Rbs , int Wbs )
	: CLineSocket( Log , Rbs , Wbs )
{                        
	ASSERT_VALID( pParent );
	m_Parent = pParent;
	m_State = SERVLISTEN;
	m_LineBuf = new char [ ServLineBufSize ];
	m_Msg = NULL;
}

CServSocket::CServSocket( tcLogger * Log , SOCKET s , CServDlg * pParent , int Rbs , int Wbs )
	: CLineSocket( Log , s , Rbs , Wbs )
{              
	ASSERT_VALID( pParent );
	m_Parent = pParent;
	m_State = SERVCOMMAND;
	m_LineBuf = new char [ ServLineBufSize ];
	m_Msg = NULL;
}                                            


CServSocket::~CServSocket()
{                    
	Close();
	delete [] m_LineBuf;
	if( m_Msg != NULL )
		delete m_Msg;
}           

    
CServSocket * CServSocket::Accept() {

#ifdef DEBUG
	logger->logf(TC_TRACE, "CServSocket(%p)::Accept()", this);
#endif
	SOCKET ns = accept(sock, NULL, NULL);
	if (ns == INVALID_SOCKET) {
		lastErr = WSAGetLastError();
		logger->logf(TC_ERROR, "tcSocket(%p): Accept failed: %s",
					 this, lastErrorMessage());
		return NULL;
	}      
	CServSocket * Ret = new CServSocket( logger , ns , m_Parent , rbSize , wbSize );
	
	return Ret;
}
 
void CServSocket::Accepted(int error )
{   
	m_Parent->Trace( 2 , "Accepting Connection on Listen Socket" );
	m_Parent->Accept( error , this );
}
                                                          
BOOL CServSocket::Init()
{
	CString Tmp = gConfig->GetHostName();
	Tmp += " SMTP Server Ready";
	SendCommand( 220 , Tmp );
	m_Msg = new CMailMessage();
	return TRUE;
}
                                                          
void CServSocket::lineRead()
{                                         
	readLine( m_LineBuf , ServLineBufSize - 1 );
	
	ASSERT( m_Msg != NULL );
	ASSERT( m_State != SERVLISTEN );
	if( m_State == SERVDATA ) 
	{
		// We're in the process of getting data
		m_Parent->Trace( 4 , m_LineBuf );
		const char * p = ParseData( m_LineBuf );
		if ( p == NULL )
		{
			// End of data
			if( m_Msg->Write( NULL ) )
			{
				SendCommand( 250 , "Ok " );
				m_Parent->ReceivedMessage();
				CString Tmp = "Received mail from ";
				Tmp += m_Msg->GetFromAddress();
				m_Parent->Trace( 0 , (const char *)Tmp );
				// Added by jwtcdoac@silicom.demon.co.uk (Jeremy Sonander)
				// to fix multiple mailboxes bug   
				m_Msg->Reset();
			}
			else
				SendCommand( 451 , "Local error in processing" );
			m_State = SERVCOMMAND;
		}
		else
			m_Msg->AddLine( p );
	}  // End Data Processing
	else
	{
		char * Arguments;                                
		m_Parent->Trace( 2 , m_LineBuf );
		servCommands Cmd = ParseCommand( m_LineBuf , Arguments );
		switch (Cmd ) {
		case HELO:  // Don't do anything clever with ESMTP;
		case EHLO:	DoHelo( Arguments ); break;
		case RCPT:  DoRcpt( Arguments ); break;
  		case DATA:  DoData( Arguments ); break;
  		case RSET:  DoRset( Arguments ); break;
  		case SEND:
  		case SOML:
  		case SAML:
  		case MAIL:	DoMail( Arguments ); break;
  		case VRFY:  DoVrfy( Arguments ); break;
  		case EXPN:  DoExpn( Arguments ); break;
  		case HELP:  DoHelp( Arguments ); break;
  		case NOOP:  DoNoop( Arguments ); break;
  		case QUIT:  DoQuit( Arguments ); break;
  		case TURN:  DoTurn( Arguments ); break;
  		case SERVERROR:    
  		default:                        
  					DoError( Arguments );      
  					break;
  		}
  	} // End Command Processing
  	return;
	
	return;
}			
 
	
void CServSocket::dataWritten()
{                       
}

void CServSocket::Connected(int error)
{                               
	delMask( FD_CONNECT );
	m_State = SERVCOMMAND;
	m_Parent->Connected( error , this );
}

void CServSocket::Closed(int error)
{
	m_Parent->Closed( error , this );
}

CServSocket::servCommands CServSocket::ParseCommand( char * Buf , char * &Arguments )
{                                         
	int i = 0;        
	for( int j = 0 ; j < 4 ; j++ )
		Buf[ j ] = (char)toupper( Buf[ j ] );
		
	while( ParseTable[ i ].Cmd != SERVERROR )
	{
		if ( strncmp( Buf , ParseTable[ i ].Str , 4 ) == 0 )
		{
			// Got it
			Arguments = (Buf + 4);
			return ParseTable[ i ].Cmd;
		}      
		i++;
	}
	// If we get here, we haven't found it
	return SERVERROR;
}

// EMK Inline this?
const char * CServSocket::ParseData( const char * p )
{            
	// A line without CRLF at the end of it has been passed
	if( *p == '.' )
	{
		p++;
		if( *p == '\0' )   
			p = NULL;
	}
	return p;                                              
}

// EMK This is pretty inefficient but.....leave for later
void CServSocket::SendCommand( int Cmd , const char * p )
{
	char Buffer[ 8 ];
	wsprintf( Buffer , "%d " , Cmd );
	CString Tmp( Buffer );
	Tmp += p;
	writeLine( Tmp );          
	m_Parent->Trace( 2 , Tmp );
}

void CServSocket::DoHelo( char * Str )
{
	SendCommand( 250 , gConfig->GetHostName() );
	CString Tmp = Str + 1;     
	m_Msg->SetSystem( Tmp );
	Tmp += " says hello";
	m_Parent->Trace( 0 , Tmp );
}

void CServSocket::DoRcpt( char * Str )
{
	// EMK Don't bother checking the TO bit at the moment
	char * p = strchr( Str , '<' );
	char * q = strchr( Str , '>' );
	if( q == NULL )
	{
		SendCommand( 500 , "Syntax error" );
		return;
	}
	else
	{
		*q = '\0';
	}
	if( p == NULL )
	{
		SendCommand( 500 , "Syntax error" );
		return;
	}
	CString Rcpt = p + 1;
	// ORM Added next 2 lines to handle funny RCTP To lines
	if ((p = strchr(Rcpt, ':')) != NULL)
		Rcpt = p + 1;
	m_Msg->SetToAddress( Rcpt );
	SendCommand( 250 , "Ok" );
}

void CServSocket::DoData( char *  )
{                                               
	SendCommand( 354 , "Start mail input; end with <CRLF>.<CRLF>" );
	m_State = SERVDATA;
}

void CServSocket::DoRset( char *  )
{                      
	m_Msg->Reset();
	SendCommand( 250 , "Ok " );	
}

void CServSocket::DoMail( char * Str )
{
	// EMK Don't bother checking the FROM bit at the moment
	char * p = strchr( Str , '<' );
	char * q = strchr( Str , '>' );
	if( q == NULL )
	{
		SendCommand( 500 , "Syntax error" );
		return;
	}
	else
	{
		*q = '\0';
	}
	if( p == NULL )
	{
		SendCommand( 500 , "Syntax error" );
		return;
	}
	CString From = p + 1;
	m_Msg->SetFromAddress( From );
	SendCommand( 250 , "Ok" );
}

void CServSocket::DoVrfy( char * )
{                           
	SendCommand( 250, "I guess they're ok" );
}

void CServSocket::DoExpn( char * )
{                              
	SendCommand( 502 , "Command not implemented" );
}

void CServSocket::DoHelp( char * )
{                                                 
	SendCommand( 211 , "No help available" );
}

void CServSocket::DoNoop( char * )
{                        
	SendCommand( 250 , "Ok" );
}

void CServSocket::DoQuit( char * )
{                                       
	CString Tmp = gConfig->GetHostName();
	Tmp += " closing";
	SendCommand( 221 , Tmp );
	Closed( 0 );
}

void CServSocket::DoTurn( char * )
{                                  
	SendCommand( 502 , "Command not implemented" );
}

void CServSocket::DoError(char * )
{                                    
	SendCommand( 500 , "What do you mean by that?" );
}


