/***********************************************************************
**
** CANIBMP.CPP
**
** Copyright 1994 by Ewan Kirk <ewan@kirk.demon.co.uk>
**
** Permission to use, copy, modify, distribute, and sell this software and its
** documentation for any purpose is hereby granted without fee, provided that
** the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of Ewan Kirk not be used in
** advertising or publicity pertaining to distribution of the software without
** specific, written prior permission.  Ewan Kirk makes no representations
** about the suitability of this software for any purpose.  It is provided
** "as is" without express or implied warranty.
**
** EWAN KIRK DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
** INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
** EVENT SHALL EWAN KIRK BE LIABLE FOR ANY SPECIAL, INDIRECT OR
** CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
** DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
** TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
** PERFORMANCE OF THIS SOFTWARE.
**
** This file is part of WINDIS. 
** It is the implementation of the CAnimatedBitmap class.
** This class responsible for animating itself in a particular
** location
**
** V1.0 - Initial Revision 01-Sep-94
**
*/
// prefdlg.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CTimeSetupDlg dialog

class CTimeSetupDlg : public CDialog
{
// Construction
public:
	CTimeSetupDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CTimeSetupDlg)
	enum { IDD = IDD_TIMESETUP };
	BOOL	m_TimeSetSystem;
	BOOL	m_StartupKick;
	BOOL	m_UseNews;
	CString	m_TimeHost;
	CString	m_TimeZone;
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CTimeSetupDlg)
	virtual void OnOK();
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
// CSetupDlg dialog

class CSetupDlg : public CDialog
{
// Construction
public:
	CSetupDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CSetupDlg)
	enum { IDD = IDD_SETUP };
	CComboBox	m_SetCombo;
	CButton	m_SetDefaultSet;
	BOOL	m_AnimatedBmp;
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CSetupDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnClickedDeleteset();
	afx_msg void OnClickedDialersetup();
	afx_msg void OnClickedMailsetup();
	afx_msg void OnClickedNewSetupSet();
	afx_msg void OnClickedNewsSetup();
	afx_msg void OnClickedPop3setup();
	afx_msg void OnClickedFingersetup();
	afx_msg void OnClickedSetdefconfig();
	afx_msg void OnClickedShortset();
	afx_msg void OnClickedTcpipsetup();
	afx_msg void OnClickedTimesetup();
	afx_msg void OnClickedTracingsetup();
	virtual void OnOK();
	afx_msg void OnSelchangeSetcombo();
	afx_msg void OnServices();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
	// Just one private function
	void DoDefaultCheck();
};
/////////////////////////////////////////////////////////////////////////////
// CNntpSetupDlg dialog

class CNntpSetupDlg : public CDialog
{
// Construction
public:
	CNntpSetupDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CNntpSetupDlg)
	enum { IDD = IDD_NNTPSETUP };
	CStatic	m_DownloadStatic;
	UINT	m_DownloadDays;
	BOOL	m_DownloadGroups;
	BOOL	m_DownloadNewGroups;
	CString	m_KA9QRoot;
	CString	m_NewsServer;
	UINT	m_NntpKickSecs;
	UINT	m_NntpBatchDepth;
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CNntpSetupDlg)
	virtual void OnOK();
	afx_msg void OnClickedDownloadgroups();
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
/////////////////////////////////////////////////////////////////////////////
// CServSetup dialog

class CServSetup : public CDialog
{
// Construction
public:
	CServSetup(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CServSetup)
	enum { IDD = IDD_MAILSETUP };
	CString	m_MailServer;
	CString	m_MailboxType;
	int		m_KickSeconds;
	BOOL	m_MailBatchMode;
	CString	m_MailOutDir;
	CString	m_MailInDir;
	UINT	m_MailSessions;
	CString	m_DefaultDelivery;
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CServSetup)
	virtual void OnOK();
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
/////////////////////////////////////////////////////////////////////////////
// CTCPIPSetup dialog

class CTCPIPSetup : public CDialog
{
// Construction
public:
	CTCPIPSetup(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CTCPIPSetup)
	enum { IDD = IDD_TCPIPSETUP };
	BOOL	m_SlipConnection;
	CString	m_HostName;
	BOOL	m_ConnectOnStartup;
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CTCPIPSetup)
	virtual void OnOK();
	afx_msg void OnClickedSlipconnection();
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
/////////////////////////////////////////////////////////////////////////////
// CTraceDlg dialog

class CTraceDlg : public CDialog
{
// Construction
public:
	CTraceDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CTraceDlg)
	enum { IDD = IDD_TRACESETUP };
	CString	m_LogFile;
	UINT	m_NntpTrace;
	UINT	m_ClientTrace;
	UINT	m_ServerTrace;
	BOOL	m_TraceSocket;
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CTraceDlg)
	virtual void OnOK();
	afx_msg void OnClickedTracesocket();
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
/////////////////////////////////////////////////////////////////////////////
// CNewSetupSetDlg dialog

class CNewSetupSetDlg : public CDialog
{
// Construction
public:
	CNewSetupSetDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CNewSetupSetDlg)
	enum { IDD = IDD_NEWSETUPSETDLG };
	CString	m_NewSetupSetName;
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CNewSetupSetDlg)
		// NOTE: the ClassWizard will add member functions here
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
/////////////////////////////////////////////////////////////////////////////
// CPrefDlg dialog

class CPrefDlg : public CDialog
{
// Construction
public:
	CPrefDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CPrefDlg)
	enum { IDD = IDD_PREFDLG };
	BOOL	m_ViewClient;
	BOOL	m_ViewServ;
	BOOL	m_ViewNews;
	int		m_StartupOption;
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CPrefDlg)
	virtual void OnOK();
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
/////////////////////////////////////////////////////////////////////////////
// CFingerSetup dialog

class CFingerSetup : public CDialog
{
// Construction
public:
	CFingerSetup(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CFingerSetup)
	enum { IDD = IDD_FINGERSETUP };
	CButton	m_FingerEdit;
	CButton	m_Delete;
	CListBox	m_ListBox;
	CString	m_FingerDefault;
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	// Generated message map functions
	//{{AFX_MSG(CFingerSetup)
	virtual void OnOK();
	afx_msg void OnFingerdelete();
	virtual BOOL OnInitDialog();
	afx_msg void OnSelchangeFingerlist();
	afx_msg void OnFingeredit();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
  private:
  	// Private functions
  	void UpdateListBox();
	void DoDefaultCheck();
  	// Private data
  	CStringArray m_FingerNames;
};
/////////////////////////////////////////////////////////////////////////////
// CFingerNewDlg dialog

class CFingerNewDlg : public CDialog
{
// Construction
public:
	CFingerNewDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CFingerNewDlg)
	enum { IDD = IDD_FINGERNEWDLG };
	CString	m_FingerNewEdit;
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CFingerNewDlg)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
/////////////////////////////////////////////////////////////////////////////
// CServiceSetup dialog

class CServiceSetup : public CDialog
{
// Construction
public:
	CServiceSetup(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CServiceSetup)
	enum { IDD = IDD_SERVICESSETUP };
	BOOL	m_CheckDisk;
	BOOL	m_CrossPost;
	BOOL	m_Remove;
	BOOL	m_BackgroundUnbatch;
	BOOL	m_UnbatchOnExit;
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CServiceSetup)
	virtual void OnOK();
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
/////////////////////////////////////////////////////////////////////////////
// CDialDialog dialog

class CDialDialog : public CDialog
{
// Construction
public:
	CDialDialog(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CDialDialog)
	enum { IDD = IDD_DIALDIALOG };
	CString	m_DialString1;
	CString	m_DialString2;
	CString	m_DialString3;
	CString	m_DialString4;
	CString	m_DialString5;
	CString	m_DialString6;
	int		m_DialInt1;
	int		m_DialInt2;
	int		m_DialInt3;
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CDialDialog)
	virtual BOOL OnInitDialog();
	virtual void OnOK();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
