/***********************************************************************
**
** CANIBMP.CPP
**
** Copyright 1994 by Ewan Kirk <ewan@kirk.demon.co.uk>
**
** Permission to use, copy, modify, distribute, and sell this software and its
** documentation for any purpose is hereby granted without fee, provided that
** the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of Ewan Kirk not be used in
** advertising or publicity pertaining to distribution of the software without
** specific, written prior permission.  Ewan Kirk makes no representations
** about the suitability of this software for any purpose.  It is provided
** "as is" without express or implied warranty.
**
** EWAN KIRK DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
** INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
** EVENT SHALL EWAN KIRK BE LIABLE FOR ANY SPECIAL, INDIRECT OR
** CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
** DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
** TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
** PERFORMANCE OF THIS SOFTWARE.
**
** This file is part of WINDIS. 
** It is the implementation of the CAnimatedBitmap class.
** This class responsible for animating itself in a particular
** location
**
** V1.0 - Initial Revision 01-Sep-94
**
*/
/////////////////////////////////////////////////////////////////////////
// message.h
//

// This class encapsulates the concept of an outgoing mail message
#ifndef _MESSAGE_H
#define _MESSAGE_H

class CMailMessage : public CObject
{
  public:                                         
  	
	CMailMessage();
	~CMailMessage();                            
	void SetToDelete() {m_OkToDelete = TRUE;}                      
	BOOL IsOkToDelete(){ return m_OkToDelete; }	
	BOOL Load(void * Data) ;
	BOOL Write(void * Data);       
	// Stuff for sending mail
	CString GetToHost()  { return m_ToHost; }
	CString GetFromAddress()  {return m_FromAddress;}
	CString GetToAddress( int i )  {return m_ToAddress.GetAt( i );} 
	int GetRecipientCount() { return m_ToAddress.GetSize(); }
	char * GetLine( char * Buffer , size_t Len );

	void DeleteFromDisk();
	
	// Stuff for receiving mail
	void 	SetSystem( CString &System )	{ m_System = System; }
	void	SetToAddress( CString &Addr ) 	{ m_ToAddress.Add( Addr ); }
	void	SetFromAddress( CString &Addr )	{ m_FromAddress = Addr; }
	BOOL	AddLine( const char * Line );
	void	Reset() { m_ToAddress.RemoveAll();m_FromAddress = ""; }
  protected: 
	CString GetMailBoxFile();
    CString m_ToHost;
    CString m_FromAddress;
    CStringArray m_ToAddress;
    CString m_System;
    CStdioFile m_BodyFile; 
    CString m_BodyFilePath;
    CString m_WorkFilePath;
    BOOL m_IsOpen;              
    BOOL m_OkToDelete;
    long m_SequenceNum;
};

class CMailMessageList : public CObList
{                       
  public:
	CMailMessageList();
	~CMailMessageList();	
    int Queued() { return GetCount() + m_Failed; }          
    int Failed() { return m_Failed; }
    int Sent()	 { return m_Sent; } 
    CMailMessage * GetNextMessage();
    void DoneMessage( BOOL Success );
  private:
    int m_Failed;
    int m_Sent;
};

#endif
