/***********************************************************************
**
** WLOCKING.CPP
**
** Copyright 1994 by Ewan Kirk <ewan@kirk.demon.co.uk>
**
** Permission to use, copy, modify, distribute, and sell this software and its
** documentation for any purpose is hereby granted without fee, provided that
** the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of Ewan Kirk not be used in
** advertising or publicity pertaining to distribution of the software without
** specific, written prior permission.  Ewan Kirk makes no representations
** about the suitability of this software for any purpose.  It is provided
** "as is" without express or implied warranty.
**
** EWAN KIRK DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
** INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
** EVENT SHALL EWAN KIRK BE LIABLE FOR ANY SPECIAL, INDIRECT OR
** CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
** DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
** TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
** PERFORMANCE OF THIS SOFTWARE.
**
** A class to handle SNEWS compatible file locks.  All you
** do is create one of these objects whenever you want to 
** lock a file.  When it goes out of scope, the destructor gets called
** and the lock gets released...clever eh?
**
** V1.0 - Initial Revision 01-Sep-94
**
*/
// A C++ Class to encapsulate the locking process used by Newswin
#include "stdafx.h"
#include <fcntl.h>
#include <io.h>
#include "newssup.h"

/*
 * create a lockfile
 */

CNewsLock::CNewsLock(const char *dir, const char *id, const char *name)
{
	int             i;
	char            lockname[_MAX_PATH], tempname[_MAX_PATH];
	int             fd;

	ASSERT( dir != NULL );
	ASSERT( id != NULL );
	ASSERT( name != NULL );	                                                         

    FileName = NULL;
    
	strcpy(tempname, id);
	if (strlen(tempname) > 8) 			  /* truncate long filenames */
		tempname[8] = '\0';
	if (tempname[7] == '\\')
		tempname[7] = '\0';
	for (i = 0; i < 7; i++)
		if (tempname[i] == '.') {
			tempname[i] = '\0';
			break;
		}

	/* Try to create the lock file in an atomic operation */
	sprintf(lockname, "%s\\%s.lck", dir, tempname);
	if ((fd = _open(lockname, O_WRONLY | O_EXCL | O_CREAT, 0600)) == -1)
		return;
	FileName = new char [ strlen( lockname ) + 1 ];
	strcpy( FileName , lockname );
	_write(fd, name, strlen(name) );
	_close(fd);
}

/*
 * remove a lockfile
 */

CNewsLock::~CNewsLock()
{
	if( FileName != NULL )
	{
		unlink( FileName );
		delete [] FileName;
	}
	return;
}           

// The Active Class
CActive::CActive( char * ActiveLine ) : Ok( FALSE ) 
{                                                  
	ASSERT( ActiveLine != NULL );
	
	char * p; 
	ASSERT( strlen(ActiveLine) != 0);
		
	if ((p = strtok(ActiveLine, " \t")) == NULL) {
		return;
	}
	
	group = p;
	
	if ((p = strtok(NULL, " \t")) == NULL) {
	}                        
	
	gp_file = p;
	
	if ((p = strtok(NULL, " \t")) == NULL) {
		return;
	}
	lo_num = atol(p);

	if ((p = strtok(NULL, " \t")) == NULL) {
		return;
	}
	hi_num = atol(p);
	m_Suspend = FALSE;
	Ok = TRUE;
}
        
	        
CString CActive::GetFileName( const char * Dir , const char * Ext )
{   
	char Buffer[ _MAX_PATH ];                           
	strcpy( Buffer , Dir );  
	strcat( Buffer , "\\" );
	strcat( Buffer , gp_file );
	strcat( Buffer , Ext );
	return Buffer;  // Get's cast into a cstring when returned and
					// so although it looks like it is returning a pointer
					// to something on the stack, it isn't really.
}
	        

CActive::~CActive()
{                                                            
	return;
	// Destructor should delete the cstrings ok
}

CActiveList::CActiveList( const char * FileName )
	: Ok( FALSE ), m_FileName( FileName ) , GroupList( NULL )
{
	ASSERT( FileName != NULL );
	
	CStdioFile TheFile;
	if ( !TheFile.Open( FileName , CFile::modeRead ) )
		return;
	char * Buf = new char[ _MAX_PATH ];
	
	GroupList = new CMapStringToOb;
		
	while( TheFile.ReadString( Buf, _MAX_PATH )  )
	{                        
		// If the line is < four characters then it's gotta be
		// a bad one.                           
		// Also, allow the use of # style comments in active
		if( strlen( Buf ) < 4 || Buf[ 0 ] == '#' )
			continue;
		CActive * Act = new CActive( Buf );
		GroupList->SetAt( Act->GetGroup() , Act );
	}
	delete [] Buf;
	Ok = TRUE;
}

CActiveList::~CActiveList()
{
	POSITION pos;                      
	CString Str;
	CActive * Act; 

	if ( GroupList != NULL )
	{ 	
		for( pos = GroupList->GetStartPosition(); pos != NULL; )
		{                  
			CObject * Obj;
			GroupList->GetNextAssoc( pos , Str , Obj );
			Act = (CActive *)Obj;
			delete Act;
		}
		GroupList->RemoveAll();
		delete GroupList;
	}
	// The m_FileName string is reclaimed automatically
}

static int compare( const void *arg1, const void *arg2 )
{
   /* Compare all of both strings: */
   return _stricmp( * ( char** ) arg1, * ( char** ) arg2 );
}

BOOL CActiveList::WriteActive()
{
    CStdioFile TheFile;
	CString Str; 
	CObject * Obj;
	CActive * Act;
	
	char buf[ _MAX_PATH ];
	int i = 0;
	int ArraySize = GroupList->GetCount();

	if ( !TheFile.Open( m_FileName , CFile::modeCreate ) )
		return FALSE;
                                              
	char ** StringArray = new char *[ ArraySize ];			
	
	for( POSITION pos = GroupList->GetStartPosition(); pos != NULL; )
	{                 
		GroupList->GetNextAssoc( pos , Str , Obj );
		Act = (CActive *)Obj;
		if( Act->IsSuspend() )
		    Str = "n";
		else
		    Str = "y";	
		wsprintf( buf , "%s %s %08ld %08ld %s\n" , 
						  Act->GetGroup() , Act->GetFile() , 
						  Act->GetLoNum() , Act->GetHiNum() ,
						  (const char *)Str );
						
		StringArray[ i ] = new char[ strlen( buf ) + 1];
		strcpy( StringArray[ i ] , buf );
		i++;
	}       
	// Ok, all these strings are in the array so now qsort them
   	qsort( (void *)StringArray, (size_t)ArraySize, sizeof( char * ), compare );
   	
   /* Output sorted list and reclaim the memory */
	for( i = 0 ; i < ArraySize ; i++ )          
	{
		TheFile.WriteString( StringArray[ i ] ); 
		delete [] StringArray[ i ];
	}
	delete [] StringArray;
	// File closed automatically as it goes out of scope	
	return TRUE;                   
}

POSITION CActiveList::GetStartPosition()
{
	return GroupList->GetStartPosition();
}

CActive * CActiveList::GetNextGroup( POSITION& pos )
{                           
	CString Str;
	CObject * Obj;
	GroupList->GetNextAssoc( pos , Str , Obj );
	return (CActive *)Obj;
}

CActive * CActiveList::FindGroup( const char * GroupName )
{                                     
	ASSERT( GroupName != NULL );
	ASSERT( strlen( GroupName ) > 0 );
	CObject * Obj;
	if( GroupList->Lookup( GroupName , Obj ) )
		return (CActive *)Obj;
	else
		return NULL;
}


