/***********************************************************************
**
** CANIBMP.CPP
**
** Copyright 1994 by Ewan Kirk <ewan@kirk.demon.co.uk>
**
** Permission to use, copy, modify, distribute, and sell this software and its
** documentation for any purpose is hereby granted without fee, provided that
** the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of Ewan Kirk not be used in
** advertising or publicity pertaining to distribution of the software without
** specific, written prior permission.  Ewan Kirk makes no representations
** about the suitability of this software for any purpose.  It is provided
** "as is" without express or implied warranty.
**
** EWAN KIRK DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
** INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
** EVENT SHALL EWAN KIRK BE LIABLE FOR ANY SPECIAL, INDIRECT OR
** CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
** DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
** TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
** PERFORMANCE OF THIS SOFTWARE.
**
** This file is part of WINDIS. 
** It is the implementation of the CAnimatedBitmap class.
** This class responsible for animating itself in a particular
** location
**
** V1.0 - Initial Revision 01-Sep-94
**
*/
// windis.h : main header file for the WINDIS application
//
// Version numbers
#define WINDIS_VERSION 10

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#ifndef _WINDIS_H
#define _WINDIS_H

#include "resource.h"		// main symbols
#ifndef _TCLOG_H
#include "tclog.h"
#endif

// WM_USER + 1x are used for dialog user messages
// WM_USER + 2x and above are used for the sockets
// WM_USER + 3x are used for sockets communicating with windows

#define WM_WINDIS_KICK		(WM_USER + 10)
#define WM_WINDIS_ABORT		(WM_USER + 11)  
#define IDT_TICK_TIMER		1  
// Tick timer is the number of seconds between running the socket
// timeout tick and the kick timer
// This is one second at the moment but it may save us
// time in the long term to make the granularity of this
// timer a little bit larger
#define TICK_TIMER	1


/////////////////////////////////////////////////////////////////////////////
// CWindisApp:
// See windis.cpp for the implementation of this class
//

class CWindisApp : public CWinApp
{
public:
	CWindisApp();

// Overrides
	virtual BOOL InitInstance();
	virtual int	ExitInstance();
	virtual BOOL OnIdle( long Count );
// Implementation

	//{{AFX_MSG(CWindisApp)
	afx_msg void OnAppAbout();
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
#ifdef _DEBUG
	CMemoryState m_StartState;
#endif	
};


/////////////////////////////////////////////////////////////////////////////
// The global configuration object

		
#define DECLAREINISTR(IniEntry) \
	public:\
		const char * Get##IniEntry() { return (const char *)IniEntry ; } \
		void Set##IniEntry( const char * Str ) { IniEntry = Str; }\
	private:\
	    CString IniEntry
	    
#define DECLAREINIINT(IniEntry) \
	public: \
		int	Get##IniEntry() { return IniEntry; }\
		void Set##IniEntry( int i ) { IniEntry = i; }\
	private:\
		int IniEntry
	    
	
class CWindisSetup 
{   
	// These are all in the global section
	DECLAREINIINT(Version);
	DECLAREINISTR(DefaultSet);
	DECLAREINIINT(AnimatedBitmaps);
	DECLAREINISTR(FingerDefault);
	DECLAREINIINT(NntpTrace);
	DECLAREINIINT(SmtpTrace);
	DECLAREINIINT(ServTrace);
	DECLAREINISTR(LogPath);
	DECLAREINIINT(SocketLogging);
	DECLAREINISTR(DefaultRecipient);
		
	// These are in the preferences section
	DECLAREINIINT(StartupOption);
	DECLAREINIINT(ViewNews);
	DECLAREINIINT(ViewSmtp);
	DECLAREINIINT(ViewServ);
	// These are in each set
	DECLAREINISTR(SetName);

	DECLAREINISTR(NewsServer);
	DECLAREINISTR(KA9QRoot);
	DECLAREINIINT(DownloadGroups);
	DECLAREINIINT(DownloadGroupsDays);
	DECLAREINIINT(DownloadGroupsLastTime);
	DECLAREINIINT(DownloadNewGroups);   
	DECLAREINIINT(NewsKickSeconds);
	DECLAREINIINT(NewsBatchDepth);
	
	DECLAREINISTR(MailOutDir);  
	DECLAREINISTR(MailInDir);
	DECLAREINISTR(MailGateway);     
	DECLAREINIINT(MailBatch);
	DECLAREINISTR(MailBoxType);
	DECLAREINIINT(MailKickSeconds);
	DECLAREINIINT(MailSessions);	
	
	DECLAREINISTR(TimeServer);
	DECLAREINIINT(TimeSetSystem);
	DECLAREINIINT(TimeStartupKick);
	DECLAREINIINT(TimeUseNews);  
	DECLAREINISTR(TimeZone);
	
	DECLAREINISTR(HostName);
	DECLAREINIINT(SlipConnection);
	DECLAREINIINT(ConnectOnStartup);
	
	DECLAREINIINT(UnbatchOptions);
	DECLAREINIINT(BackgroundUnbatch);
	DECLAREINIINT(UnbatchOnExit);
	              
	// these are used for setting up dialer	              
	DECLAREINISTR(DialString1);
	DECLAREINISTR(DialString2);
	DECLAREINISTR(DialString3);
	DECLAREINISTR(DialString4);
	DECLAREINISTR(DialString5);
	DECLAREINISTR(DialString6);
	DECLAREINIINT(DialInt1);
	DECLAREINIINT(DialInt2);
	DECLAREINIINT(DialInt3);
	
  public:
  	CWindisSetup();
  	~CWindisSetup();        
	CStringArray * GetSetupSetList();
  	
  public: // Set manipulation functions
	void WriteCurrentSet();
	void LoadCurrentSet();
	void WriteGlobalSet();
	CString GetDefaultSetName();
	CString GetCurrentSetName();   
	void SetDefaultSetName( const char * Str);
	void SetCurrentSetName( const char * Str);
	void GetSetupSetNames( CStringArray &StrArray);
	void NewSetupSet( const char * From, const char * New );
	BOOL CurrentIsDefault();	
	void DeleteSetupSet( const char * Name );
	
	void GetFingerNames( CStringArray &StrArray );
	void SetFingerNames( CStringArray &StrArray );	
	void SetFingerFont( const LOGFONT* plf );
	void GetFingerFont(LOGFONT* plf);
	  	
  protected:
  	void Init();
	CString GetCurrentSet();
	int FindSetIndex( const char * Name );
	CString FindFreeIndex();
	CString MakeIndex( int i );
	CString NameToSet(const char * Name);
	CString SetToName( const char * Name );
	CString MakeFingerIndex( int i );
  private:
  	static BOOL m_FirstTime;
  	CString CurrentSet;

};


///////////////////////////////////////////
// Global Variables

// The global configuration object
extern CWindisSetup * gConfig;

// A string to determine that there is a free slot in the finger
// array
extern const char * FreeFingerStr;
                                            
// The global message System identification String
extern const char * SystemWindowTitle;
#endif
