// Copyright 1993 by Peter Bentley <pete@tecc.co.uk>
//
// Permission to use, copy, modify, distribute, and sell this software and its
// documentation for any purpose is hereby granted without fee, provided that
// the above copyright notice appear in all copies and that both that
// copyright notice and this permission notice appear in supporting
// documentation, and that the name of Peter Bentley not be used in
// advertising or publicity pertaining to distribution of the software without
// specific, written prior permission.  Peter Bentley makes no representations
// about the suitability of this software for any purpose.  It is provided
// "as is" without express or implied warranty.
//
// PETER BENTLEY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
// INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
// EVENT SHALL PETER BENTLEY BE LIABLE FOR ANY SPECIAL, INDIRECT OR
// CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
// DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
// TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
// PERFORMANCE OF THIS SOFTWARE.
//  
// The logger object for the tcclasses.
// See pete for info.
#include "stdafx.h"
#include <stdarg.h>
#include <ctype.h>
#include <errno.h>

#include "tclog.h"

#define TCLOG_BUF_SIZE 1024

/////////////////////////////////////////////////////////////////////////////
// tcLogger names for error levels
//
const char *tcLogger::logLevelName[] = {
	"Debug",
	"Trace",
    "Start operation",
	"Information",
	"Enter state",
	"WARNING",
	"ERROR",
};

tcLogger::tcLogger()
{
	m_Buffer = new char[ TCLOG_BUF_SIZE ];
}                      

tcLogger::~tcLogger()
{
	delete [] m_Buffer;
}

/////////////////////////////////////////////////////////////////////////////
// tcLogger default logf() function
void tcLogger::logf(tcLogLevel lev, const char *fmt, ...) {
	va_list	args;

	va_start(args, fmt);
	vsprintf(m_Buffer, fmt, args);
	va_end(args);
	log(lev, m_Buffer);
}

