/***********************************************************************
**
** prefdlg.CPP
**
** Copyright 1994 by Ewan Kirk <ewan@kirk.demon.co.uk>
**
** Permission to use, copy, modify, distribute, and sell this software and its
** documentation for any purpose is hereby granted without fee, provided that
** the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of Ewan Kirk not be used in
** advertising or publicity pertaining to distribution of the software without
** specific, written prior permission.  Ewan Kirk makes no representations
** about the suitability of this software for any purpose.  It is provided
** "as is" without express or implied warranty.
**
** EWAN KIRK DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
** INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
** EVENT SHALL EWAN KIRK BE LIABLE FOR ANY SPECIAL, INDIRECT OR
** CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
** DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
** TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
** PERFORMANCE OF THIS SOFTWARE.
**
** This file is part of WINDIS. 
**
** All the dialogs.  All done in PCode.  All done in the same
** easily maintainable way.  Be nice if it could be tabbed dlg boxes
** but what the hell.
**
** V1.0 - Initial Revision 01-Sep-94
**
*/
// prefdlg.cpp : implementation file
//

#include "stdafx.h"
#include "windis.h"         
#include "newssup.h"
#include "utility.h"
#include "prefdlg.h"

// turn pcode on
#pragma optimize( "q" , on )

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSetupDlg dialog

CSetupDlg::CSetupDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSetupDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSetupDlg)
	m_AnimatedBmp = gConfig->GetAnimatedBitmaps();
	//}}AFX_DATA_INIT
}

void CSetupDlg::DoDataExchange(CDataExchange* pDX)
{            
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSetupDlg)
	DDX_Control(pDX, IDC_SETCOMBO, m_SetCombo);
	DDX_Control(pDX, IDC_SETDEFCONFIG, m_SetDefaultSet);
	DDX_Check(pDX, IDC_ANIMATED, m_AnimatedBmp);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSetupDlg, CDialog)
	//{{AFX_MSG_MAP(CSetupDlg)
	ON_BN_CLICKED(IDC_DELETESET, OnClickedDeleteset)
	ON_BN_CLICKED(IDC_DIALERSETUP, OnClickedDialersetup)
	ON_BN_CLICKED(IDC_MAILSETUP, OnClickedMailsetup)
	ON_BN_CLICKED(IDC_NEWSET, OnClickedNewSetupSet)
	ON_BN_CLICKED(IDC_NEWSSETUP, OnClickedNewsSetup)
	ON_BN_CLICKED(IDC_POP3SETUP, OnClickedPop3setup)
	ON_BN_CLICKED(IDC_FINGERSETUP, OnClickedFingersetup)
	ON_BN_CLICKED(IDC_SETDEFCONFIG, OnClickedSetdefconfig)
	ON_BN_CLICKED(IDC_SHORTSET, OnClickedShortset)
	ON_BN_CLICKED(IDC_TCPIPSETUP, OnClickedTcpipsetup)
	ON_BN_CLICKED(IDC_TIMESETUP, OnClickedTimesetup)
	ON_BN_CLICKED(IDC_TRACINGSETUP, OnClickedTracingsetup)
	ON_CBN_SELCHANGE(IDC_SETCOMBO, OnSelchangeSetcombo)
	ON_BN_CLICKED(IDC_SERVICES, OnServices)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSetupDlg message handlers
/////////////////////////////////////////////////////////////////////////////
// CTimeSetupDlg message handlers

BOOL CSetupDlg::OnInitDialog()
{                             
	CDialog::OnInitDialog();
	// Add the strings to the listbox
	CenterWindow();
	CStringArray StrArray;
	gConfig->GetSetupSetNames( StrArray );
	for( int i = 0 ; i < StrArray.GetSize() ; i++ )
	{                      
		m_SetCombo.AddString( StrArray[ i ] );
	}                                
	int Sel = m_SetCombo.SelectString( -1 , gConfig->GetCurrentSetName() );
	ASSERT( Sel != CB_ERR );
	DoDefaultCheck();
	return TRUE;  // return TRUE  unless you set the focus to a control
}
                                         
void CSetupDlg::DoDefaultCheck()
{
	if( gConfig->CurrentIsDefault() )
		m_SetDefaultSet.SetCheck( 1 );
	else
		m_SetDefaultSet.SetCheck( 0 );    
}
                                         
void CSetupDlg::OnSelchangeSetcombo()
{
	int Sel = m_SetCombo.GetCurSel(); 
	if( Sel != LB_ERR )
	{
		CString Text;
		m_SetCombo.GetLBText( Sel , Text );
		ASSERT( Text.GetLength() != 0 );
		gConfig->SetCurrentSetName( Text );
		DoDefaultCheck();
	}
}


void CSetupDlg::OnClickedDialersetup()
{
	CDialDialog Dlg;
	Dlg.DoModal();
}

void CSetupDlg::OnClickedMailsetup()
{
	// TODO: Add your control notification handler code here
	CServSetup Dlg;
	Dlg.DoModal();	
}

void CSetupDlg::OnClickedNewSetupSet()
{
	CNewSetupSetDlg Dlg;
	Dlg.m_NewSetupSetName = "";
	if( Dlg.DoModal() == IDOK && Dlg.m_NewSetupSetName.GetLength() != 0 )
	{                
		CString Text;
		int Sel = m_SetCombo.GetCurSel();
		ASSERT( Sel != LB_ERR );
		m_SetCombo.GetLBText( Sel , Text );
		gConfig->NewSetupSet( Text , Dlg.m_NewSetupSetName );
		m_SetCombo.AddString( Dlg.m_NewSetupSetName );
		Sel = m_SetCombo.SelectString( -1 , Dlg.m_NewSetupSetName );
		ASSERT( Sel != CB_ERR );
		DoDefaultCheck();
	}
}
void CSetupDlg::OnClickedDeleteset()
{
	CString Text;                                     
	int Sel = m_SetCombo.GetCurSel();
	ASSERT( Sel != LB_ERR );
	m_SetCombo.GetLBText( Sel , Text );
	gConfig->DeleteSetupSet( Text );
	m_SetCombo.DeleteString( Sel );
	
	// And now set the selection to number 0
	Text = gConfig->GetCurrentSetName();
	Sel = m_SetCombo.SelectString( -1 , Text );
	ASSERT( Sel != CB_ERR );
	DoDefaultCheck();		
}

void CSetupDlg::OnClickedNewsSetup()
{
	// TODO: Add your control notification handler code here
	CNntpSetupDlg Dlg;
	Dlg.DoModal();
	
}

void CSetupDlg::OnClickedPop3setup()
{                 
	::MsgBox( MB_OK | MB_ICONINFORMATION ,
			  IDS_MSG_NOT_IMPLEMENTED );
}

void CSetupDlg::OnClickedFingersetup()
{
	CFingerSetup Dlg;
	Dlg.DoModal();
}


void CSetupDlg::OnClickedSetdefconfig()
{                                    
	CString Text; 
	int Selected = m_SetDefaultSet.GetCheck();
	if( Selected != 0 )                
	{   
		int Sel = m_SetCombo.GetCurSel();        
		ASSERT( Sel != CB_ERR );
		m_SetCombo.GetLBText( Sel , Text );
		gConfig->SetDefaultSetName( Text );
		m_SetDefaultSet.SetCheck( 1 );
	}
}


void CSetupDlg::OnClickedShortset()
{
	// TODO: Add your control notification handler code here
	
}

void CSetupDlg::OnClickedTcpipsetup()
{
	// TODO: Add your control notification handler code here
	CTCPIPSetup Dlg;
	Dlg.DoModal();	
}

void CSetupDlg::OnClickedTimesetup()
{
	// TODO: Add your control notification handler code here
	// Create a time dialog and execute it
	CTimeSetupDlg Dlg; 
	Dlg.DoModal();
}

void CSetupDlg::OnClickedTracingsetup()
{
	// TODO: Add your control notification handler code here
	CTraceDlg Dlg;
	Dlg.DoModal();	
}

void CSetupDlg::OnServices()
{
	CServiceSetup Dlg;
	Dlg.DoModal();
}

void CSetupDlg::OnOK()
{
	CDialog::OnOK();
	gConfig->SetAnimatedBitmaps( m_AnimatedBmp );
//	gConfig->SetCurrentSetName( m_ShortCutCombo );
//	if( m_SetDefaultSet )
//		gConfig->SetDefaultSetName( m_ShortCutCombo );
	gConfig->WriteGlobalSet();
}

/////////////////////////////////////////////////////////////////////////////
// CTimeSetupDlg dialog

CTimeSetupDlg::CTimeSetupDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTimeSetupDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTimeSetupDlg)
	m_TimeSetSystem = gConfig->GetTimeSetSystem();
	m_StartupKick = gConfig->GetTimeStartupKick();
	m_UseNews = gConfig->GetTimeUseNews();
	m_TimeHost = gConfig->GetTimeServer();
	m_TimeZone = gConfig->GetTimeZone();
	//}}AFX_DATA_INIT
}


void CTimeSetupDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTimeSetupDlg)
	DDX_Check(pDX, IDC_TIMESETSYSTEM, m_TimeSetSystem);
	DDX_Check(pDX, IDC_TIMESTARTUPKICK, m_StartupKick);
	DDX_Check(pDX, IDC_TIMEUSENEWS, m_UseNews);
	DDX_Text(pDX, IDC_TIMEHOSTEDIT, m_TimeHost);
	DDX_Text(pDX, IDC_TIMETIMEZONE, m_TimeZone);
	DDV_MaxChars(pDX, m_TimeZone, 128);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CTimeSetupDlg, CDialog)
	//{{AFX_MSG_MAP(CTimeSetupDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CTimeSetupDlg::OnOK()
{
	// 	Set the data from the dialog box
	CDialog::OnOK();  // This calls update data
	
	gConfig->SetTimeSetSystem( m_TimeSetSystem );
	gConfig->SetTimeStartupKick( m_StartupKick );
	gConfig->SetTimeUseNews( m_UseNews );
	gConfig->SetTimeServer( m_TimeHost ); 
	gConfig->SetTimeZone( m_TimeZone );
	gConfig->WriteCurrentSet();
}


/////////////////////////////////////////////////////////////////////////////
// CNntpSetupDlg dialog

CNntpSetupDlg::CNntpSetupDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CNntpSetupDlg::IDD, pParent)
{
	// DownloadGroupsLastTime();
	//{{AFX_DATA_INIT(CNntpSetupDlg)
	m_DownloadDays = gConfig->GetDownloadGroupsDays();
	m_DownloadGroups = gConfig->GetDownloadGroups();
	m_DownloadNewGroups = gConfig->GetDownloadNewGroups();
	m_KA9QRoot = gConfig->GetKA9QRoot();
	m_NewsServer = gConfig->GetNewsServer();
	m_NntpKickSecs = gConfig->GetNewsKickSeconds();
	m_NntpBatchDepth = gConfig->GetNewsBatchDepth();
	//}}AFX_DATA_INIT
}

void CNntpSetupDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CNntpSetupDlg)
	DDX_Control(pDX, IDC_DOWNLOADSTATIC, m_DownloadStatic);
	DDX_Text(pDX, IDC_DOWNLOADDAYS, m_DownloadDays);
	DDV_MinMaxUInt(pDX, m_DownloadDays, 0, 365);
	DDX_Check(pDX, IDC_DOWNLOADGROUPS, m_DownloadGroups);
	DDX_Check(pDX, IDC_DOWNLOADNEWGROUPS, m_DownloadNewGroups);
	DDX_Text(pDX, IDC_KA9QROOT, m_KA9QRoot);
	DDX_Text(pDX, IDC_NEWSSERVER, m_NewsServer);
	DDX_Text(pDX, IDC_NNTPKICKSECS, m_NntpKickSecs);
	DDV_MinMaxUInt(pDX, m_NntpKickSecs, 0, 3600);
	DDX_Text(pDX, IDC_NNTPBATCHDEPTH, m_NntpBatchDepth);
	DDV_MinMaxUInt(pDX, m_NntpBatchDepth, 1, 12);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CNntpSetupDlg, CDialog)
	//{{AFX_MSG_MAP(CNntpSetupDlg)
	ON_BN_CLICKED(IDC_DOWNLOADGROUPS, OnClickedDownloadgroups)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNntpSetupDlg message handlers

void CNntpSetupDlg::OnOK()
{
	CDialog::OnOK();
	gConfig->SetDownloadGroupsDays(m_DownloadDays);
	gConfig->SetDownloadGroups(m_DownloadGroups);
	gConfig->SetDownloadNewGroups(m_DownloadNewGroups);          
	// Nuke the trailing \\ if there is one
	CString Tmp = m_KA9QRoot;
	// Nuke any trailing "\"
	if( m_KA9QRoot[ m_KA9QRoot.GetLength() - 1] == '\\' )
		Tmp = m_KA9QRoot.Left( m_KA9QRoot.GetLength() - 1 );
		
	gConfig->SetKA9QRoot( Tmp );
	gConfig->SetNewsServer(m_NewsServer);
	gConfig->SetNewsKickSeconds(m_NntpKickSecs);
	gConfig->SetNewsBatchDepth( m_NntpBatchDepth );
	gConfig->WriteCurrentSet();
}

void CNntpSetupDlg::OnClickedDownloadgroups()
{
	// TODO: Add your control notification handler code here
	
}
/////////////////////////////////////////////////////////////////////////////
// CServSetup dialog

CServSetup::CServSetup(CWnd* pParent /*=NULL*/)
	: CDialog(CServSetup::IDD, pParent)
{
	//{{AFX_DATA_INIT(CServSetup)
	m_MailServer = gConfig->GetMailGateway();
	m_MailboxType = gConfig->GetMailBoxType();
	m_KickSeconds = gConfig->GetMailKickSeconds();
	m_MailBatchMode = gConfig->GetMailBatch();
	m_MailOutDir = gConfig->GetMailOutDir();
	m_MailInDir = gConfig->GetMailInDir();
	m_MailSessions = gConfig->GetMailSessions();
	m_DefaultDelivery = gConfig->GetDefaultRecipient();
	//}}AFX_DATA_INIT
}

void CServSetup::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CServSetup)
	DDX_Text(pDX, IDC_MAILSERVER, m_MailServer);
	DDX_CBString(pDX, IDC_MAILBOXTYPE, m_MailboxType);
	DDX_Text(pDX, IDC_SMTPKICKSECONDS, m_KickSeconds);
	DDV_MinMaxInt(pDX, m_KickSeconds, 0, 3600);
	DDX_Check(pDX, IDC_MAIL_BATCH_MODE, m_MailBatchMode);
	DDX_Text(pDX, IDC_MAIL_OUT_DIR, m_MailOutDir);
	DDV_MaxChars(pDX, m_MailOutDir, _MAX_PATH);
	DDX_Text(pDX, IDC_MAIL_IN_DIR, m_MailInDir);
	DDV_MaxChars(pDX, m_MailInDir, 128);
	DDX_Text(pDX, IDC_SMTPMAILSESSIONS, m_MailSessions);
	DDV_MinMaxUInt(pDX, m_MailSessions, 1, 10);
	DDX_Text(pDX, IDC_DEFAULT_DELIVERY_USER, m_DefaultDelivery);
	DDV_MaxChars(pDX, m_DefaultDelivery, 8);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CServSetup, CDialog)
	//{{AFX_MSG_MAP(CServSetup)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CServSetup message handlers

void CServSetup::OnOK()
{       
	if( !ValidateFileName( m_DefaultDelivery ) )
	{
		::MsgBox( MB_OK | MB_ICONSTOP , "Default delivery user must not contain invalid MSDOS characters" );
		return;
	};
	CDialog::OnOK();
	gConfig->SetMailGateway(m_MailServer);
	gConfig->SetMailBoxType(m_MailboxType);
	gConfig->SetMailKickSeconds(m_KickSeconds);
	gConfig->SetMailBatch(m_MailBatchMode);
	gConfig->SetMailOutDir(m_MailOutDir);
	gConfig->SetMailInDir(m_MailInDir);        
	gConfig->SetMailSessions(m_MailSessions);     
	gConfig->SetDefaultRecipient(m_DefaultDelivery);
	gConfig->WriteCurrentSet();    
	gConfig->WriteGlobalSet();
}
/////////////////////////////////////////////////////////////////////////////
// CTCPIPSetup dialog

CTCPIPSetup::CTCPIPSetup(CWnd* pParent /*=NULL*/)
	: CDialog(CTCPIPSetup::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTCPIPSetup)
	m_SlipConnection = gConfig->GetSlipConnection();
	m_HostName = gConfig->GetHostName();
	m_ConnectOnStartup = gConfig->GetConnectOnStartup();
	//}}AFX_DATA_INIT
}

void CTCPIPSetup::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTCPIPSetup)
	DDX_Check(pDX, IDC_SLIPCONNECTION, m_SlipConnection);
	DDX_Text(pDX, IDC_HOSTNAME, m_HostName);
	DDX_Check(pDX, IDC_CONNECTONSTARTUP, m_ConnectOnStartup);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CTCPIPSetup, CDialog)
	//{{AFX_MSG_MAP(CTCPIPSetup)
	ON_BN_CLICKED(IDC_SLIPCONNECTION, OnClickedSlipconnection)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTCPIPSetup message handlers

void CTCPIPSetup::OnOK()
{
	CDialog::OnOK();
	gConfig->SetSlipConnection(m_SlipConnection);
	gConfig->SetHostName(m_HostName);
	gConfig->SetConnectOnStartup(m_ConnectOnStartup);
	gConfig->WriteCurrentSet();
}

void CTCPIPSetup::OnClickedSlipconnection()
{
	// TODO: Add your control notification handler code here
	
}
/////////////////////////////////////////////////////////////////////////////
// CTraceDlg dialog

CTraceDlg::CTraceDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTraceDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTraceDlg)
	m_LogFile = gConfig->GetLogPath();
	m_NntpTrace = gConfig->GetNntpTrace();
	m_ClientTrace = gConfig->GetSmtpTrace();
	m_ServerTrace = gConfig->GetServTrace();
	m_TraceSocket = gConfig->GetSocketLogging();
	//}}AFX_DATA_INIT
}

void CTraceDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTraceDlg)
	DDX_Text(pDX, IDC_LOGFILE, m_LogFile);
	DDX_Text(pDX, IDC_NNTPTRACE, m_NntpTrace);
	DDV_MinMaxUInt(pDX, m_NntpTrace, 0, 7);
	DDX_Text(pDX, IDC_SMTPCLITRACE, m_ClientTrace);
	DDV_MinMaxUInt(pDX, m_ClientTrace, 0, 7);
	DDX_Text(pDX, IDC_SMTPSERVTRACE, m_ServerTrace);
	DDV_MinMaxUInt(pDX, m_ServerTrace, 0, 7);
	DDX_Check(pDX, IDC_TRACESOCKET, m_TraceSocket);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CTraceDlg, CDialog)
	//{{AFX_MSG_MAP(CTraceDlg)
	ON_BN_CLICKED(IDC_TRACESOCKET, OnClickedTracesocket)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTraceDlg message handlers

void CTraceDlg::OnOK()
{
	CDialog::OnOK();
	gConfig->SetLogPath(m_LogFile);
	gConfig->SetNntpTrace(m_NntpTrace);
	gConfig->SetSmtpTrace(m_ClientTrace);
	gConfig->SetServTrace(m_ServerTrace);
	gConfig->SetSocketLogging(m_TraceSocket);
	gConfig->WriteGlobalSet();
}

void CTraceDlg::OnClickedTracesocket()
{
		
}
/////////////////////////////////////////////////////////////////////////////
// CNewSetupSetDlg dialog

CNewSetupSetDlg::CNewSetupSetDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CNewSetupSetDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CNewSetupSetDlg)
	m_NewSetupSetName = "";
	//}}AFX_DATA_INIT
}

void CNewSetupSetDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CNewSetupSetDlg)
	DDX_Text(pDX, IDC_NEWSETUPSETNAME, m_NewSetupSetName);
	DDV_MaxChars(pDX, m_NewSetupSetName, 30);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CNewSetupSetDlg, CDialog)
	//{{AFX_MSG_MAP(CNewSetupSetDlg)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNewSetupSetDlg message handlers



/////////////////////////////////////////////////////////////////////////////
// CPrefDlg dialog


CPrefDlg::CPrefDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPrefDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPrefDlg)
	m_ViewClient = gConfig->GetViewSmtp();
	m_ViewServ = gConfig->GetViewServ();
	m_ViewNews = gConfig->GetViewNews();
	m_StartupOption = gConfig->GetStartupOption();
	//}}AFX_DATA_INIT
}

void CPrefDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPrefDlg)
	DDX_Check(pDX, IDC_PREV_VIEW_CLIENT, m_ViewClient);
	DDX_Check(pDX, IDC_PREF_VIEW_SERV, m_ViewServ);
	DDX_Check(pDX, IDC_PREF_VIEW_NEWS, m_ViewNews);
	DDX_Radio(pDX, IDC_PREF_DO_NOTHING, m_StartupOption);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPrefDlg, CDialog)
	//{{AFX_MSG_MAP(CPrefDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CPrefDlg message handlers

void CPrefDlg::OnOK()
{
	CDialog::OnOK();
	// Get the data out of the variables
	gConfig->SetViewNews( m_ViewNews );
	gConfig->SetViewServ( m_ViewServ );
	gConfig->SetViewSmtp( m_ViewClient );
	gConfig->SetStartupOption( m_StartupOption );
	gConfig->WriteGlobalSet();
}
/////////////////////////////////////////////////////////////////////////////
// CFingerSetup dialog


CFingerSetup::CFingerSetup(CWnd* pParent /*=NULL*/)
	: CDialog(CFingerSetup::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFingerSetup)
	m_FingerDefault = gConfig->GetFingerDefault();
	//}}AFX_DATA_INIT
	// And initialise the array of finger strings
	gConfig->GetFingerNames(m_FingerNames);
}

void CFingerSetup::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFingerSetup)
	DDX_Control(pDX, IDC_FINGEREDIT, m_FingerEdit);
	DDX_Control(pDX, IDC_FINGERDELETE, m_Delete);
	DDX_Control(pDX, IDC_FINGERLIST, m_ListBox);
	DDX_Text(pDX, IDC_FINGER_SETUP_DEFAULT, m_FingerDefault);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CFingerSetup, CDialog)
	//{{AFX_MSG_MAP(CFingerSetup)
	ON_BN_CLICKED(IDC_FINGERDELETE, OnFingerdelete)
	ON_LBN_SELCHANGE(IDC_FINGERLIST, OnSelchangeFingerlist)
	ON_BN_CLICKED(IDC_FINGEREDIT, OnFingeredit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CFingerSetup message handlers

void CFingerSetup::OnOK()
{
	// TODO: Add extra validation here
	
	CDialog::OnOK();                     
	gConfig->SetFingerNames( m_FingerNames );
	gConfig->SetFingerDefault( m_FingerDefault );
}

void CFingerSetup::OnFingeredit()
{
	CFingerNewDlg Dlg;                   
	int Sel = m_ListBox.GetCurSel();
	if( Sel != -1 )
	{
		CString Text;
		m_ListBox.GetText( Sel , Text );
		if( Text != FreeFingerStr )
		Dlg.m_FingerNewEdit = Text;
	}
	if( Dlg.DoModal() == IDOK )
	{
		// Get the string out of m_FingerNewEdit;
		// Add to the list box;
		int Sel = m_ListBox.GetCurSel();
		m_FingerNames[ Sel ] = Dlg.m_FingerNewEdit;
		UpdateListBox();
		m_ListBox.SetSel( Sel , TRUE );
	}	
}
                                              
void CFingerSetup::UpdateListBox()
{       
	m_ListBox.ResetContent();
	for( int i = 0 ; i < m_FingerNames.GetSize() ; i++ )
	{
		m_ListBox.AddString( m_FingerNames[ i ] );
	}
}
		                                              
void CFingerSetup::OnFingerdelete()
{
	int Sel = m_ListBox.GetCurSel();
	
	if ( Sel != -1 )
	{                           
		m_FingerNames[ Sel ] = FreeFingerStr;
		UpdateListBox();
		m_ListBox.SetSel( Sel , TRUE );
	}
}


BOOL CFingerSetup::OnInitDialog()
{
	CDialog::OnInitDialog();
	CenterWindow();
	// Add the strings to the listbox
	UpdateListBox();
	m_ListBox.SetSel( 0 , TRUE );
	return TRUE;  // return TRUE  unless you set the focus to a control
}                  


void CFingerSetup::OnSelchangeFingerlist()
{
	// TODO: Add your control notification handler code here
	int Sel = m_ListBox.GetCurSel();
	if( Sel != -1 )
	{
		m_FingerEdit.EnableWindow( TRUE );
		CString Text;
		m_ListBox.GetText( Sel , Text );
		if ( Text != FreeFingerStr )
			m_Delete.EnableWindow( TRUE );
		else
			m_Delete.EnableWindow( FALSE );
	}
	else
	{
		m_FingerEdit.EnableWindow( FALSE );
		m_Delete.EnableWindow( FALSE );
	}					
}
		
/////////////////////////////////////////////////////////////////////////////
// CFingerNewDlg dialog


CFingerNewDlg::CFingerNewDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CFingerNewDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFingerNewDlg)
	m_FingerNewEdit = "";
	//}}AFX_DATA_INIT
}

void CFingerNewDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFingerNewDlg)
	DDX_Text(pDX, IDC_FINGER_NEW_EDIT, m_FingerNewEdit);
	DDV_MaxChars(pDX, m_FingerNewEdit, 128);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CFingerNewDlg, CDialog)
	//{{AFX_MSG_MAP(CFingerNewDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CFingerNewDlg message handlers


BOOL CFingerNewDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CenterWindow();
	SetWindowText( "New Finger Entry" );	
	return TRUE;  // return TRUE  unless you set the focus to a control
}
/////////////////////////////////////////////////////////////////////////////
// CServiceSetup dialog

CServiceSetup::CServiceSetup(CWnd* pParent /*=NULL*/)
	: CDialog(CServiceSetup::IDD, pParent)
{                                     
	int Option = gConfig->GetUnbatchOptions();
	//{{AFX_DATA_INIT(CServiceSetup)
	m_CheckDisk = Option & UNBATCH_CHECKDISK;
	m_CrossPost = Option & UNBATCH_CROSSPOST_TO_JUNK;
	m_Remove = Option & UNBATCH_REMOVE_BATCH;
	m_BackgroundUnbatch = gConfig->GetBackgroundUnbatch();
	m_UnbatchOnExit = gConfig->GetUnbatchOnExit();
	//}}AFX_DATA_INIT
}

void CServiceSetup::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CServiceSetup)
	DDX_Check(pDX, IDC_BATCHCHECKDISK, m_CheckDisk);
	DDX_Check(pDX, IDC_BATCHCROSSPOST, m_CrossPost);
	DDX_Check(pDX, IDC_BATCHREMOVE, m_Remove);
	DDX_Check(pDX, IDC_BACKGROUNDUNBATCH, m_BackgroundUnbatch);
	DDX_Check(pDX, IDC_BATCHONEXIT, m_UnbatchOnExit);
	//}}AFX_DATA_MAP
}
BEGIN_MESSAGE_MAP(CServiceSetup, CDialog)
	//{{AFX_MSG_MAP(CServiceSetup)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
/////////////////////////////////////////////////////////////////////////////
// CServiceSetup message handlers

void CServiceSetup::OnOK()
{
	CDialog::OnOK();                     
	// Now unpack the stuff into the option variable
	int Option = 0;
	if( m_CheckDisk ) Option |= UNBATCH_CHECKDISK;
	if( m_CrossPost ) Option |= UNBATCH_CROSSPOST_TO_JUNK;
	if( m_Remove )	  Option |= UNBATCH_REMOVE_BATCH;    
	gConfig->SetUnbatchOptions( Option );	             
	gConfig->SetBackgroundUnbatch( m_BackgroundUnbatch );
	gConfig->SetUnbatchOnExit( m_UnbatchOnExit );
	gConfig->WriteCurrentSet();
}


BOOL CNntpSetupDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CenterWindow();
	return TRUE;  // return TRUE  unless you set the focus to a control
}

BOOL CPrefDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CenterWindow();	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

BOOL CServiceSetup::OnInitDialog()
{
	CDialog::OnInitDialog();
	CenterWindow();
	return TRUE;  // return TRUE  unless you set the focus to a control
}

BOOL CServSetup::OnInitDialog()
{
	CDialog::OnInitDialog();
	CenterWindow();	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

BOOL CTCPIPSetup::OnInitDialog()
{
	CDialog::OnInitDialog();
	CenterWindow();	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

BOOL CTimeSetupDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CenterWindow();	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

BOOL CTraceDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CenterWindow();	
	return TRUE;  // return TRUE  unless you set the focus to a control
}
/////////////////////////////////////////////////////////////////////////////
// CDialDialog dialog


CDialDialog::CDialDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CDialDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDialDialog)
	m_DialString1 = gConfig->GetDialString1();
	m_DialString2 = gConfig->GetDialString2();
	m_DialString3 = gConfig->GetDialString3();
	m_DialString4 = gConfig->GetDialString4();
	m_DialString5 = gConfig->GetDialString5();
	m_DialString6 = gConfig->GetDialString6();
	m_DialInt1 = gConfig->GetDialInt1();
	m_DialInt2 = gConfig->GetDialInt2();
	m_DialInt3 = gConfig->GetDialInt3();
	//}}AFX_DATA_INIT
}

void CDialDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDialDialog)
	DDX_Text(pDX, IDC_DIALSTRING1, m_DialString1);
	DDX_Text(pDX, IDC_DIALSTRING2, m_DialString2);
	DDX_Text(pDX, IDC_DIALSTRING3, m_DialString3);
	DDX_Text(pDX, IDC_DIALSTRING4, m_DialString4);
	DDX_Text(pDX, IDC_DIALSTRING5, m_DialString5);
	DDX_Text(pDX, IDC_DIALSTRING6, m_DialString6);
	DDX_Text(pDX, IDC_DIALINT1, m_DialInt1);
	DDX_Text(pDX, IDC_DIALINT2, m_DialInt2);
	DDX_Text(pDX, IDC_DIALINT3, m_DialInt3);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDialDialog, CDialog)
	//{{AFX_MSG_MAP(CDialDialog)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CDialDialog message handlers

BOOL CDialDialog::OnInitDialog()
{
	CDialog::OnInitDialog();
	CenterWindow();	
	return TRUE;  // return TRUE  unless you set the focus to a control
}


void CDialDialog::OnOK()
{
	CDialog::OnOK();
	gConfig->SetDialString1( m_DialString1 );	
	gConfig->SetDialString2( m_DialString2 );	
	gConfig->SetDialString3( m_DialString3 );	
	gConfig->SetDialString4( m_DialString4 );	
	gConfig->SetDialString5( m_DialString5 );	
	gConfig->SetDialString6( m_DialString6 );	
	gConfig->SetDialInt1( m_DialInt1 );	
	gConfig->SetDialInt2( m_DialInt2 );	
	gConfig->SetDialInt3( m_DialInt3 );	
	gConfig->WriteCurrentSet();
}
