/***********************************************************************
**
** CANIBMP.CPP
**
** Copyright 1994 by Ewan Kirk <ewan@kirk.demon.co.uk>
**
** Permission to use, copy, modify, distribute, and sell this software and its
** documentation for any purpose is hereby granted without fee, provided that
** the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of Ewan Kirk not be used in
** advertising or publicity pertaining to distribution of the software without
** specific, written prior permission.  Ewan Kirk makes no representations
** about the suitability of this software for any purpose.  It is provided
** "as is" without express or implied warranty.
**
** EWAN KIRK DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
** INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
** EVENT SHALL EWAN KIRK BE LIABLE FOR ANY SPECIAL, INDIRECT OR
** CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
** DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
** TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
** PERFORMANCE OF THIS SOFTWARE.
**
** This file is part of WINDIS. 
** It is the implementation of the CAnimatedBitmap class.
** This class responsible for animating itself in a particular
** location
**
** V1.0 - Initial Revision 01-Sep-94
**
*/
// csocket.h The definition file for the csocket classes
//
#ifndef _CSOCKET_H
#define _CSOCKET_H

#ifndef _TCSOCK_H
#include "tcsock.h"
#endif
#ifndef _TCLOG_H
#include "tclog.h"
#endif                        

// we need to define these classes as forward
class CFingerWnd;
class CTimeDlg;

// Socket defines                   
#define WM_SOCK_BASE		(WM_USER + 30)
#define WM_SOCK_CLOSE		(WM_SOCK_BASE + 1 )
#define WM_TIME_READ		(WM_SOCK_BASE + 2 )


// The global function that allocates a logger
tcLogger * AllocateLogger( const char * Name );

// This is a simple little socket class to handle times
// It never traces or anything
class CTimeSocket : public tcBufSocket
{   
  public:
	CTimeSocket( tcLogger * Log , CTimeDlg * pParent , int Rbs = 1024 , int Wbs = 1024 );
    virtual ~CTimeSocket();
  protected:
    // The overridden read and write functions
    virtual void dataRead(); 
    virtual void dataWritten();
    virtual void Connected(int);
	virtual void Timeout();		
    //virtual void Accepted(int)  		{;} // No accepted stuff here
    virtual void Closed(int);
	 //virtual void OOBData(int)			{;} // We're not interested when it send OOBData
  private:
    CTimeDlg * m_Parent;
};    

// This class is the base for all the socket classes (apart from the time
// socket) in the application.  A fairly cheap and dirty wrapper round
// tcCRLFLineSocket
// Mostly involved in timeout manipulation
class CLineSocket : public tcCRLFLineBufSocket
{
  public:
	CLineSocket( tcLogger * Log , int Rbs = 1024 , int Wbs = 1024 );
	CLineSocket( tcLogger * Log , SOCKET s , int Rbs = 1024 , int Wbs = 1024 );
    ~CLineSocket();	                                        
};

// A socket to handle finger info.
class CFingerSocket : public CLineSocket
{   
  public:
	CFingerSocket( tcLogger * Log , CFingerWnd * pParent , int Rbs = 4092 , int Wbs = 1024 );
    virtual ~CFingerSocket();
  protected:
    // The overridden read and write functions
    virtual void lineRead(); 
    virtual void dataWritten() {;}
    virtual void Connected(int error);
	virtual void Closed( int error ); 		
	virtual void Timeout();		
  private:
    CFingerWnd * m_Parent;
};    

// A wrapper for lists of sockets
class CSocketList : public CPtrList
{
  public:
  	CSocketList() : CPtrList() {;}
  	virtual ~CSocketList();
  	POSITION AddTail( tcSocket * p ) { return CPtrList::AddTail( (void *) p ); }
  	tcSocket * GetHead() {return (tcSocket *)CPtrList::GetHead(); }
  	tcSocket * RemoveHead() { return (tcSocket *)CPtrList::RemoveHead(); }
  	POSITION Find( tcSocket * p ) { return CPtrList::Find( (void *)p ); }
  	tcSocket * GetAt( POSITION p ) { return (tcSocket *)CPtrList::GetAt( p ); } 
};          

		
#endif
    
