*  Program 
*  Application : INITEST.EXE
*  Purpose     : oFgIni.lib sample program
*  File Name   : INITEST.PRG
*  Author      : Felix H. Gonzalez
*  Date created: 01-30-94
*  Time created: 07:54:40am
*  Make File   : MAKE.BAT
*  Exec File   : INITEST.EXE
*  Copyright   : 1994 by Felix H. Gonzalez
*  Compile     : /n /w
*  Notes       :
*              :
*              :
* 

MEMVAR GETLIST

function Main()
  LOCAL oFile // test for FgFileIo
  //create the object and open or create the file
  LOCAL oIni := oFgIni():New():Use("TEST.INI")

  // get a logical value
  LOCAL lValue1 := oIni:GetVal( "SectionName", "LogicalVar", .T.)

  // get a numeric value
  LOCAL nValue2 := oIni:GetVal( "SectionName", "NumberVar", 100)

  // get a char string
  LOCAL cValue3 := oIni:GetVal( "Section", ;
                                  "CharVar", "ValName", 10 )

  // get a date value
  LOCAL dValue4 := oIni:GetVal("Section","DateVar",  Date() )

  // using oIni in SetColor()
  SetColor( oIni:GetVal("Color","ScreenColor", "w/b" ) )
  SET SCOREBOARD OFF
  CLEAR SCREEN

  @ 0,0 say PadC( "Testing oFgIni.lib", maxCol() + 1) ;
    color oIni:GetVal("Color","WhiteRB", "w+/rb" )

  @ Row()+2, 1  SAY "Value1:" GET lValue1 ;
    COLOR oIni:GetVal("Color","BlueWhite", "b/w" )

  @ Row()+1, 1  SAY "Value2:" GET nValue2 PICTURE"99999" ;
    COLOR oIni:GetVal("Color","RedWhite", "r/w" )

  @ Row()+1, 1  SAY "Value3:" GET cValue3 PICTURE "@K";
    COLOR oIni:GetVal("Color","WhiteRed", "w/r" )

  @ Row()+1, 1  SAY "Value4:" GET DValue4

  READ

  SET COLOR TO
  CLEAR SCREEN
  ? lValue1
  ? nValue2
  ? cValue3
  ? dValue4
  ? "See test.ini file."
  ? "You may edit the values in test ini and re-run the program."
  ?


  // save new values. ::SetVal() may be called to build the
  // ini file first before calling GetValue.
  oIni:SetVal( "SectionName", "LogicalVar", lValue1 )
  oIni:SetVal( "SectionName", "NumberVar", nValue2 )

  oIni:SetVal( "Section", "CharVar", cValue3 )
  oIni:SetVal( "Section", "DateVar", dValue4 )

  oIni:Use()
  // oIni:Use() saves the new values to file. oIni:Save() does the same.

  // small sample of FgFileIo object
  oFile := FgFileIO():New("Test.Ini")

  if oFile:Exists()
    ofile:Open()
    ? "Testing FgFileIo"
    ? "File Name     : " + oFile:cName
    ? "File Date     : " + dtoc( oFile:Fdate() )
    ? "File Time     : " + oFile:FTime()
    ? "File Attribute: " + oFile:Attrib()
    ? "File Exists   : " + IIF( oFile:Exists(), ".t.", ".f.")
    ? "File IsEof    : " + IIF( oFile:IsEof(), ".t.", ".f.")
    ? "File Position : " + ltrim( str( oFile:Pos() ))
    ? "File Size     : " + ltrim( str( oFile:Size() ))
    ?
    oFile:Copyto( "Test2.ini")
    oFile:Close()
  endif

return(NIL)
