#ifndef _MODULE_DES3_H_
#define _MODULE_DES3_H_

/*
 *             des3 - NBS Data Encryption Standard Library
 *
 *         Copyright (c) 1992,93,94 by SWS. All Rights Reserved.
 *       Stefan Wolf Software; Gartenstr 22; D-61449 Steinbach/Ts.
 *           FAX: +49 (0) 6171 980483; CI$ Email: 100111,140
 *
 *    Synopsis:	desXinit(keyX)
 * Description: intializes all DES arrays and permutation tables
 *              X = 1 for single, X = 2 for double, X = 3 for triple DES
 *       Input: keyX - (X * 64) -bit DES key
 *      Output: none
 *
 *    Synopsis: desXYcode(inblock,outblock)
 * Description: encrypts (Y=en) or decrypts (Y=de) 64-bit inblock to 
 *              64-bit outblock , X = [1|2|3] for DES mode
 *	 Input: inblock  - pointer to 64-bit buffer of input data
 *              outblock - pointer to 64-bit buffer for output data
 *      Output: none        
 *                 
 */

typedef unsigned char uchar;

#ifdef MSWIN16
extern void far pascal des1init(uchar far *key1);
extern void far pascal des1encode(uchar far *inblock, uchar far *outblock);
extern void far pascal des1decode(uchar far *inblock, uchar far *outblock);
extern void far pascal des2init(uchar far *key2);
extern void far pascal des2encode(uchar far *inblock, uchar far *outblock);
extern void far pascal des2decode(uchar far *inblock, uchar far *outblock);
extern void far pascal des3init(uchar far *key3);
extern void far pascal des3encode(uchar far *inblock, uchar far *outblock);
extern void far pascal des3decode(uchar far *inblock, uchar far *outblock);
#else
extern void  des1init(uchar *key1);
extern void  des1encode(uchar *inblock, uchar *outblock);
extern void  des1decode(uchar *inblock, uchar *outblock);
extern void  des2init(uchar *key2);
extern void  des2encode(uchar *inblock, uchar *outblock);
extern void  des2decode(uchar *inblock, uchar *outblock);
extern void  des3init(uchar *key3);
extern void  des3encode(uchar *inblock, uchar *outblock);
extern void  des3decode(uchar *inblock, uchar *outblock);
#endif
#endif