(**************************************************************************\
|                                                                          |
|This unit contains alot of the graphic procedures I use. It also contains |
|a pause procedure.                                                        |
|                                            Zaskoda                       |
\**************************************************************************)

Unit Aids;

Interface

Uses Crt,Graph;

Procedure TxtOut(Txt:String;X,Y,Txtcol,Shade,Light:Word);
          {This procedure writes text to a graphic screen in a
           3D effect. It's just for looks.}
Procedure Box3D(X1,Y1,X2,Y2,Light,Shade:Word);
          {This procedure draws a 3D rectangle. It's used in
           various places.}
Procedure Pause;
          {Simple pause procedure.}
Procedure BlankForm(X,Y:integer);
          {Clears a graphic block to display a square that does
           not contain a life form}
Procedure LifeForm(X,Y:integer);
          {This procedure draws a creature in a square to represent
           life.}
Procedure TitleScreen;
          {Just a simple title screen to tell what the program is
           and who wrote it.}
Procedure MenuScreen(Prtr,Death:Boolean;GenLoop:Word);
          {This draws the basic Main Menu of the program.}
Procedure DrawGrid;
          {This simpley draws the grid on wich the LifeForms are
           represented graphically}

Implementation

Procedure TxtOut(Txt:String;X,Y,Txtcol,Shade,Light:Word);
 Begin
  SetColor(Light);                 {Pretty simple, first it draws the     }
  outtextxy(X-1,Y-1,Txt);          {highlighted protion of the text, next }
  outtextxy(X,Y-1,Txt);            {the shaded section, and then the main }
  outtextxy(X-1,Y,Txt);            {color of the text.                    }
  SetColor(Shade);
  outtextxy(X+1,Y+1,Txt);
  outtextxy(X,Y+1,Txt);
  outtextxy(X+1,Y,Txt);
  SetColor(Txtcol);
  outtextxy(X,Y,Txt);
 End;

Procedure Box3D(x1,y1,x2,y2,Light,Shade:Word);
 Begin
  SetColor(Light);                 {Just like a rectangle, but it uses    }
  line(x1,y1,x2,y1);               {two colors to produce a 3D effect.    }
  line(x1,y1,x1,y2);
  SetColor(Shade);
  line(x1,y2,x2,y2);
  line(x2,y1,x2,y2);
 End;

Procedure Pause;
 Var
  Count:Word;
 Begin
  For Count:=1 to 50 do            {First it clears the keyboard buffer of}
   if keypressed then readkey;     {previous keypresses then it pauses    }
  readkey;                         {until the next key is pressed.        }
 End;

Procedure BlankForm(X,Y:integer);  {Just a lightgray box}
 Begin
  SetFillStyle(solidfill,LightGray);
  Bar(x+2,y+2,x+18,y+18);
 End;

Procedure LifeForm(X,Y:integer);   {Just a simple little picture, nothing }
 Begin                             {so complicated that it would slow the }
  SetFillStyle(SolidFill,Brown);   {system down to much                   }
  SetColor(Red);
  FillEllipse(x+10,y+10,5,8);
  Setfillstyle(Solidfill,White);
  FillEllipse(x+6,y+5,3,2);
  FillEllipse(x+14,y+5,3,2);
  Putpixel(x+6,y+5,Black);
  PutPixel(x+14,y+5,Black);
  SetColor(LightGray);
  Ellipse(x+10,y+18,5,175,6,7);
  Ellipse(x+10,y+18,5,175,7,6);
 End;

Procedure TitleScreen;             {This uses some of the previously      }
 Var                               {defined procedures                    }
  Count:Word;                      {It is fairly simple as well           }
 Begin
  ClearDevice;
  For Count:=0 to 3 do
  Box3D(Count,Count,getmaxx-Count,getmaxy-Count,White,DarkGray);
  Box3D(100,90,getmaxx-100,280,DarkGray,White);
  Box3D(100,10,getmaxx-100,70,DarkGray,White);
  SetTextStyle(10,0,17);
  TxtOut('Life',150,20,LightBlue,Blue,White);
  SetTextStyle(10,0,4);
  TxtOut('The Game of',150,0,LightGray,Blue,White);
  SetTextStyle(10,0,2);
  TxtOut('Written by: Zaskdoda',140,340,LightGray,Blue,White);
  TxtOut('   press any key',140,420,LightGray,DarkGray,White);
  Pause;
  ClearDevice;
 End;

Procedure MenuScreen(Prtr,Death:Boolean;GenLoop:Word);
 Var                               {This procedure is called many times by}
  Count:Word;                      {the main program. It just draws the   }
  Dat  :String;                    {graphic portion of the Main Menu.     }
 Begin                             {It also displays the status of the    }
  ClearDevice;                     {printer and death toggles and the     }
  SetBKColor(LightGray);           {number of times the GenLoop will run. }
  For Count:=0 to 3 do
  Box3D(Count,Count,getmaxx-Count,getmaxy-Count,White,DarkGray);
  Box3D(80,90,300,135,DarkGray,White);
  Box3D(80,190,300,235,DarkGray,White);
  Box3D(80,290,300,335,DarkGray,White);
  Box3D(340,90,560,135,DarkGray,White);
  Box3D(340,190,560,235,DarkGray,White);
  Box3D(565,200,620,230,White,DarkGray);
  Box3D(340,290,560,335,DarkGray,White);
  Box3D(565,300,620,330,White,DarkGray);
  Box3D(200,370,440,415,DarkGray,White);
  Box3D(445,380,500,410,White,DarkGray);
  SetTextStyle(2,0,7);
  TxtOut('1',100,100,LightRed,Red,Yellow);
  TxtOut('2',100,200,LightRed,Red,Yellow);
  TxtOut('3',100,300,LightRed,Red,Yellow);
  TxtOut('4',350,100,LightRed,Red,Yellow);
  TxtOut('5',350,200,LightRed,Red,Yellow);
  TxtOut('6',350,300,LightRed,Red,Yellow);
  TxtOut('7',230,380,LightRed,Red,Yellow);
  TxtOut('  Load  File',100,100,LightGray,Blue,White);
  TxtOut('  Save  File',100,200,LightGray,Blue,White);
  TxtOut('  Edit  File',100,300,LightGray,Blue,White);
  TxtOut('  Run   File',350,100,LightGray,Blue,White);
  TxtOut('  Generations',350,200,LightGray,Blue,White);
  TxtOut('  Halt with death?',350,300,LightGray,Blue,White);
  TxtOut('  Printer Toggle',230,380,LightGray,Blue,White);
  Str(GenLoop,Dat);
  TxtOut(Dat,577,205,Green,Black,LightGreen);
  If Death then  TxtOut('On',577,305,Green,Black,LightGreen) else
    TxtOut('Off',575,305,Green,Black,LightGreen);
  If Prtr then  TxtOut('On',457,385,Green,Black,LightGreen) else
    TxtOut('Off',455,385,Green,Black,LightGreen);
  TxtOut('Esc-Exit',275,20,LightGray,DarkGray,White);
 End;

Procedure DrawGrid;
 Var                               {Mostly this procedure arranges 3Dboxes}
  Count1,Count2 :Word;             {to design a background to display the }
 Begin                             {status of the life forms              }
  ClearDevice;
  For Count1:=0 to 3 do
  Box3D(Count1,Count1,getmaxx-Count1,getmaxy-Count1,White,DarkGray);
  Box3D(199,39,601,441,White,DarkGray);
  For Count1:=0 to 19 do
  For Count2:=0 to 19 do
   Box3D(201+Count1*20,41+count2*20,219+count1*20,59+count2*20,DarkGray,White);
 End;

End.